/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.logger;

import android.text.TextUtils;
import com.tencent.qcloud.network.QCloudRequestManager;
import com.tencent.qcloud.network.tools.RecordLog;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class QCloudLogger {
    private static boolean enableDebug = true;
    private static boolean enableInfo = true;
    private static boolean enableWarn = true;
    private static boolean enableError = true;
    private static String FLAG = "XmlCos";

    private QCloudLogger() {
    }

    public static void disableDebug() {
        enableDebug = false;
    }

    public static void enableDebug() {
        enableDebug = true;
        enableInfo = true;
        enableWarn = true;
        enableError = true;
    }

    public static void disableInfo() {
        enableInfo = false;
    }

    public static void enableInfo() {
        enableInfo = true;
        enableWarn = true;
        enableError = true;
    }

    public static void disableWarn() {
        enableWarn = false;
    }

    public static void enableWarn() {
        enableWarn = true;
        enableError = true;
    }

    public static void disableError() {
        enableError = false;
    }

    public static void enableError() {
        enableError = true;
    }

    public static void reset() {
        QCloudLogger.enableDebug();
    }

    public static void debug(Logger logger, String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (enableDebug && enableInfo && enableWarn && enableError) {
            logger.debug(message);
            RecordLog recordLog = RecordLog.getInstance(QCloudRequestManager.context, FLAG);
            recordLog.appendRecord(logger.getName(), "D", message, null);
        }
    }

    public static void debug(Logger logger, String message, Object ... objects) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (enableDebug && enableInfo && enableWarn && enableError) {
            logger.debug(message, objects);
            RecordLog recordLog = RecordLog.getInstance(QCloudRequestManager.context, FLAG);
            recordLog.appendRecord(logger.getName(), "D", QCloudLogger.format(message, objects), null);
        }
    }

    public static void info(Logger logger, String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (enableInfo && enableWarn && enableError) {
            logger.info(message);
            RecordLog recordLog = RecordLog.getInstance(QCloudRequestManager.context, FLAG);
            recordLog.appendRecord(logger.getName(), "I", message, null);
        }
    }

    public static void info(Logger logger, String message, Object ... objects) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (enableInfo && enableWarn && enableError) {
            logger.info(message, objects);
            RecordLog recordLog = RecordLog.getInstance(QCloudRequestManager.context, FLAG);
            recordLog.appendRecord(logger.getName(), "I", QCloudLogger.format(message, objects), null);
        }
    }

    public static void warn(Logger logger, String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (enableWarn && enableError) {
            logger.warn(message);
            RecordLog recordLog = RecordLog.getInstance(QCloudRequestManager.context, FLAG);
            recordLog.appendRecord(logger.getName(), "W", message, null);
        }
    }

    public static void warn(Logger logger, String message, Object ... objects) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (enableWarn && enableError) {
            logger.warn(message, objects);
            RecordLog recordLog = RecordLog.getInstance(QCloudRequestManager.context, FLAG);
            recordLog.appendRecord(logger.getName(), "W", QCloudLogger.format(message, objects), null);
        }
    }

    public static void error(Logger logger, String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (enableError) {
            logger.error(message);
            RecordLog recordLog = RecordLog.getInstance(QCloudRequestManager.context, FLAG);
            recordLog.appendRecord(logger.getName(), "E", message, null);
        }
    }

    public static void error(Logger logger, String message, Object ... objects) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (enableError) {
            logger.error(message, objects);
            RecordLog recordLog = RecordLog.getInstance(QCloudRequestManager.context, FLAG);
            recordLog.appendRecord(logger.getName(), "E", QCloudLogger.format(message, objects), null);
        }
    }

    private static String format(String format, Object arg1, Object arg2) {
        return MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
    }

    private static String format(String format, Object[] args) {
        return MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage();
    }
}

