/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.interceptors;

import com.tencent.qcloud.network.interceptors.LoggerInterceptor;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.RealResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferToStandardResponseInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(LoggerInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        QCloudLogger.debug(this.logger, String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        if (response.code() == 204 && response.body().contentLength() > 0L) {
            QCloudLogger.info(this.logger, "http code is 204");
            Response.Builder builder = response.newBuilder();
            builder.body((ResponseBody)new RealResponseBody(null, null));
            response = builder.build();
        }
        return response;
    }
}

