/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.interceptors;

import com.tencent.qcloud.network.logger.QCloudLogger;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(LoggerInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        QCloudLogger.debug(this.logger, String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        QCloudLogger.debug(this.logger, String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }
}

