/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.exception;

public enum QCloudExceptionType {
    UNDEFINE("undefine", 0),
    REQUEST_PARAMETER_INCORRECT("request parameter setting incorrect", 1),
    REQUEST_EXECUTE_FAILED("request execute failed", 2),
    REQUEST_USER_CANCELLED("user cancelled request", 3),
    HTTP_RESPONSE_BODY_PARSE_JSON_FAILED("http response body parse json failed", 4),
    HTTP_RESPONSE_JSON_PARSE_OBJECT_FAILED("http response json parse object failed", 5),
    UNSUPPORTED_ENCODING("unsupported encoding", 6),
    WRITE_READ_LOCAL_FILE_FAILED("write or read local file failed", 7),
    HTTP_RESPONSE_PARSE_FAILED("http response parse failed", 8),
    CLASS_TRANSFORM_FAILED("class transform failed", 9),
    CALCULATE_SIGNATURE_FAILED("calculate signature failed.", 10),
    NON_STANDARD_HTTP_RESPONSE("non standard http response", 11);

    String message;
    int code;

    private QCloudExceptionType(String message, int code) {
        this.message = message;
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }

    public static QCloudExceptionType getQCloudExceptionType(int code) {
        switch (code) {
            case 1: {
                return REQUEST_PARAMETER_INCORRECT;
            }
            case 2: {
                return REQUEST_EXECUTE_FAILED;
            }
            case 3: {
                return REQUEST_USER_CANCELLED;
            }
            case 4: {
                return HTTP_RESPONSE_BODY_PARSE_JSON_FAILED;
            }
            case 5: {
                return HTTP_RESPONSE_JSON_PARSE_OBJECT_FAILED;
            }
            case 6: {
                return UNSUPPORTED_ENCODING;
            }
            case 7: {
                return WRITE_READ_LOCAL_FILE_FAILED;
            }
            case 8: {
                return HTTP_RESPONSE_PARSE_FAILED;
            }
            case 9: {
                return CLASS_TRANSFORM_FAILED;
            }
        }
        return UNDEFINE;
    }
}

