/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.cosv4;

import android.text.TextUtils;
import com.tencent.qcloud.network.auth.KeyValuesHelper;
import com.tencent.qcloud.network.auth.QCloudSignatureSourceSerializer;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.tools.QCloudStringTools;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosV4SignatureSourceSerializer
implements QCloudSignatureSourceSerializer {
    private Logger logger = LoggerFactory.getLogger(CosV4SignatureSourceSerializer.class);
    private long duration;
    private String bucket;
    private String cosPath;

    public CosV4SignatureSourceSerializer(String bucket, String cosPath, long duration) {
        this.duration = duration;
        this.bucket = bucket;
        this.cosPath = cosPath;
    }

    public CosV4SignatureSourceSerializer(long duration) {
        this(null, null, duration);
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String source(Map<String, String> keyValues) {
        long currentTime = System.currentTimeMillis() / 1000L;
        Random random = new Random(currentTime);
        if (this.duration > 0L) {
            keyValues.put("e", String.valueOf(currentTime + this.duration));
        } else {
            keyValues.put("e", String.valueOf(0));
        }
        keyValues.put("t", String.valueOf(currentTime));
        keyValues.put("r", String.valueOf(Math.abs(random.nextInt() % 10000)));
        keyValues.put("b", this.bucket);
        String fileId = this.cosPath;
        if (!TextUtils.isEmpty((CharSequence)fileId)) {
            try {
                fileId = QCloudStringTools.urlEncode(fileId);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            fileId = String.format(Locale.ENGLISH, "/%s/%s%s", keyValues.get("a"), keyValues.get("b"), fileId);
        } else {
            fileId = "";
        }
        QCloudLogger.debug(this.logger, "file id is {}", fileId);
        keyValues.put("f", fileId);
        return KeyValuesHelper.source(keyValues);
    }
}

