/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.auth;

import android.net.Uri;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValuesHelper {
    private static Logger logger = LoggerFactory.getLogger(KeyValuesHelper.class);

    public static String source(Map<String, String> keyValues) {
        if (keyValues == null) {
            return null;
        }
        StringBuilder source = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            if (!first) {
                source.append("&");
            }
            source.append(entry.getKey() + "=" + entry.getValue());
            first = false;
        }
        return source.toString();
    }

    public static String queryStringForKeys(HttpUrl httpUrl, Set<String> keys, Set<String> realKeys) {
        StringBuilder out = new StringBuilder();
        boolean isFirst = true;
        LinkedList<String> orderKeys = new LinkedList<String>();
        for (String key : keys) {
            orderKeys.add(key.toLowerCase());
        }
        Collections.sort(orderKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        Set queryNames = httpUrl.queryParameterNames();
        if (queryNames == null) {
            return "";
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        for (String name : queryNames) {
            maps.put(name.toLowerCase(), name);
        }
        for (String key : orderKeys) {
            List values = httpUrl.queryParameterValues((String)maps.get(key));
            if (values == null) continue;
            for (String value : values) {
                if (!isFirst) {
                    out.append('&');
                }
                isFirst = false;
                realKeys.add(key.toLowerCase());
                out.append(key.toLowerCase());
                if (value == null) continue;
                out.append('=');
                out.append(value.toLowerCase());
            }
        }
        return out.toString();
    }

    public static String headersStringForKeys(Headers headers, Set<String> keys, Set<String> realKeys) {
        StringBuilder out = new StringBuilder();
        boolean isFirst = true;
        LinkedList<String> orderKeys = new LinkedList<String>();
        for (String key : keys) {
            orderKeys.add(key.toLowerCase());
        }
        Collections.sort(orderKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        QCloudLogger.debug(logger, "order keys is" + ((Object)orderKeys).toString());
        Set headerNames = headers.names();
        if (headerNames == null) {
            return "";
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        for (String name : headerNames) {
            maps.put(name.toLowerCase(), name);
        }
        for (String key : orderKeys) {
            List values = headers.values(key);
            if (values == null) continue;
            for (String value : values) {
                if (!isFirst) {
                    out.append('&');
                }
                isFirst = false;
                out.append(key.toLowerCase());
                realKeys.add(key);
                if (value == null) continue;
                out.append('=');
                out.append(Uri.encode((String)value));
            }
        }
        return out.toString();
    }
}

