/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.action;

import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.action.QCloudRequestAction;
import com.tencent.qcloud.network.auth.QCloudCredentialProvider;
import com.tencent.qcloud.network.auth.QCloudSignatureSourceSerializer;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudSignatureAction
extends QCloudRequestAction {
    private Logger logger = LoggerFactory.getLogger(QCloudSignatureAction.class);
    private QCloudCredentialProvider credentialProvider;

    public QCloudSignatureAction(QCloudHttpRequest httpRequest, QCloudCredentialProvider credentialProvider) {
        super(httpRequest);
        this.credentialProvider = credentialProvider;
    }

    @Override
    public void execute() throws Exception {
        if (this.credentialProvider == null) {
            return;
        }
        QCloudSignatureSourceSerializer credentialSourceSerializer = this.credentialProvider.getSourceSerializer();
        QCloudSignatureSourceSerializer requestSourceSerializer = this.httpRequest.getSourceSerializer();
        if (requestSourceSerializer != null) {
            this.credentialProvider.setSourceSerializer(requestSourceSerializer);
        }
        if (this.credentialProvider.getSourceSerializer() != null) {
            String signature = this.credentialProvider.signature(this.httpRequest);
            Request.Builder builder = this.httpRequest.getHttpRequest().newBuilder();
            builder.addHeader("Authorization", signature);
            this.httpRequest.setHttpRequest(builder.build());
        }
        this.credentialProvider.setSourceSerializer(credentialSourceSerializer);
    }
}

