/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network;

import com.tencent.qcloud.network.QCloudResultListener;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.Comparator;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QCloudRequest {
    private static long requestIdCounter = 1L;
    private Logger logger = LoggerFactory.getLogger(QCloudRequest.class);
    private final long requestId;
    protected QCloudRequestPriority priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
    private QCloudResultListener resultListener;
    private CountDownLatch countDownLatch;
    private boolean started;
    private boolean cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QCloudRequest() {
        Class<QCloudRequest> clazz = QCloudRequest.class;
        synchronized (QCloudRequest.class) {
            this.requestId = requestIdCounter++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void startBlock() throws InterruptedException {
        this.countDownLatch = new CountDownLatch(1);
        this.countDownLatch.await();
    }

    void finishBlock() {
        this.countDownLatch.countDown();
    }

    synchronized boolean start() {
        if (!this.started && !this.cancelled) {
            this.started = true;
            return true;
        }
        return false;
    }

    synchronized boolean cancel() {
        QCloudLogger.debug(this.logger, "cancel request {}, cancel status is {}", this.requestId, this.cancelled);
        if (this.cancelled) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public void setResultListener(QCloudResultListener resultListener) {
        this.resultListener = resultListener;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public QCloudRequestPriority getPriority() {
        return this.priority;
    }

    public QCloudResultListener getResultListener() {
        return this.resultListener;
    }

    public static enum QCloudRequestPriority {
        Q_CLOUD_REQUEST_PRIORITY_HIGH(2),
        Q_CLOUD_REQUEST_PRIORITY_NORMAL(1),
        Q_CLOUD_REQUEST_PRIORITY_LOW(0);

        int value;

        private QCloudRequestPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static class QCloudRequestComparator
    implements Comparator<QCloudRequest> {
        QCloudRequestComparator() {
        }

        @Override
        public int compare(QCloudRequest o1, QCloudRequest o2) {
            return o1.priority.getValue() - o2.priority.getValue();
        }
    }
}

