/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network;

import android.util.Log;
import com.tencent.qcloud.network.HttpRequestSerializerListener;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.QCloudServiceConfig;
import com.tencent.qcloud.network.action.QCloudActionManager;
import com.tencent.qcloud.network.action.QCloudActionResultListener;
import com.tencent.qcloud.network.action.QCloudRequestAction;
import com.tencent.qcloud.network.auth.QCloudSignatureSourceSerializer;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.QCloudOkHttpRequestBuilder;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseBodySerializer;
import com.tencent.qcloud.network.response.serializer.http.ResponseSerializer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QCloudHttpRequest
extends QCloudRequest {
    private static final Logger logger = LoggerFactory.getLogger(QCloudHttpRequest.class);
    protected List<QCloudRequestAction> requestActions = new LinkedList<QCloudRequestAction>();
    protected RequestBodySerializer requestBodySerializer = null;
    int blockTaskSuccessNumber = 0;
    protected ResponseSerializer responseSerializer = null;
    protected ResponseBodySerializer responseBodySerializer = null;
    protected QCloudOkHttpRequestBuilder requestOriginBuilder = new QCloudOkHttpRequestBuilder();
    Request httpRequest;
    protected Map<String, String> signKeyValues = new HashMap<String, String>();
    private volatile Call call = null;
    protected QCloudSignatureSourceSerializer sourceSerializer;
    private QCloudRequestAction signatureAction;

    public abstract void build();

    void serialize(final QCloudActionManager actionManager, QCloudServiceConfig serviceConfig, final HttpRequestSerializerListener serializerListener) {
        if (this.requestBodySerializer != null) {
            this.requestOriginBuilder.body(this.requestBodySerializer.serialize());
        }
        this.httpRequest = this.requestOriginBuilder.build();
        this.executeBlockActions(actionManager, serviceConfig, new QCloudActionResultListener(){

            @Override
            public void onSuccess(QCloudRequestAction action) {
                if (QCloudHttpRequest.this.signatureAction != null) {
                    QCloudHttpRequest.this.signature(actionManager, serializerListener);
                } else {
                    serializerListener.onSuccess(QCloudHttpRequest.this);
                }
            }

            @Override
            public void onFailed(QCloudRequestAction action, QCloudException exception) {
                serializerListener.onFailed(QCloudHttpRequest.this, exception);
            }
        });
    }

    private void executeBlockActions(QCloudActionManager actionManager, QCloudServiceConfig serviceConfig, final QCloudActionResultListener resultListener) {
        if (this.requestActions.size() > 0) {
            for (QCloudRequestAction action : this.requestActions) {
                action.setActionResultListener(new QCloudActionResultListener(){

                    @Override
                    public void onSuccess(QCloudRequestAction action) {
                        QCloudLogger.debug(logger, "block task success");
                        if (QCloudHttpRequest.this.hasFinishAllBlockTask(QCloudHttpRequest.this.requestActions.size())) {
                            QCloudLogger.debug(logger, "all block task has success");
                            resultListener.onSuccess(action);
                        } else {
                            QCloudLogger.debug(logger, "not all block task has success");
                        }
                    }

                    @Override
                    public void onFailed(QCloudRequestAction action, QCloudException exception) {
                        QCloudLogger.debug(logger, "block task failed");
                        QCloudHttpRequest.this.cancelAllBlockTask();
                        resultListener.onFailed(action, exception);
                    }
                });
                Log.i((String)"TAG", (String)"action manager execute");
                actionManager.execute(action);
            }
        } else {
            resultListener.onSuccess(null);
        }
    }

    void signature(QCloudActionManager actionManager, final HttpRequestSerializerListener serializerListener) {
        this.signatureAction.setActionResultListener(new QCloudActionResultListener(){

            @Override
            public void onSuccess(QCloudRequestAction action) {
                QCloudLogger.debug(logger, "calculate signature is success");
                QCloudLogger.debug(logger, "http request is build success");
                serializerListener.onSuccess(QCloudHttpRequest.this);
            }

            @Override
            public void onFailed(QCloudRequestAction action, QCloudException exception) {
                QCloudLogger.debug(logger, "calculate signature failed");
                serializerListener.onFailed(QCloudHttpRequest.this, new QCloudException(QCloudExceptionType.CALCULATE_SIGNATURE_FAILED));
            }
        });
        actionManager.execute(this.signatureAction);
    }

    void cancelAllBlockTask() {
        for (QCloudRequestAction requestAction : this.requestActions) {
            if (requestAction == null) continue;
            requestAction.cancel();
        }
    }

    public void setSign(String sign) {
        this.requestOriginBuilder.header("Authorization", sign);
    }

    synchronized boolean httpStart() {
        return super.start();
    }

    void setCall(Call call) {
        this.call = call;
    }

    Call getCall() {
        return this.call;
    }

    synchronized boolean httpCancel() {
        if (!super.cancel()) {
            return false;
        }
        this.cancelAllBlockTask();
        this.cancelCall();
        return true;
    }

    private void cancelCall() {
        if (this.call != null) {
            this.call.cancel();
        }
    }

    public Map<String, String> getSignKeyValues() {
        return this.signKeyValues;
    }

    public QCloudOkHttpRequestBuilder getRequestOriginBuilder() {
        return this.requestOriginBuilder;
    }

    public List<QCloudRequestAction> getRequestActions() {
        return this.requestActions;
    }

    synchronized boolean hasFinishAllBlockTask(int max) {
        ++this.blockTaskSuccessNumber;
        return this.blockTaskSuccessNumber >= max;
    }

    public ResponseSerializer getResponseSerializer() {
        return this.responseSerializer;
    }

    public ResponseBodySerializer getResponseBodySerializer() {
        return this.responseBodySerializer;
    }

    public QCloudSignatureSourceSerializer getSourceSerializer() {
        return this.sourceSerializer;
    }

    public void setSourceSerializer(QCloudSignatureSourceSerializer sourceSerializer) {
        this.sourceSerializer = sourceSerializer;
    }

    public void setSignatureAction(QCloudRequestAction signatureAction) {
        this.signatureAction = signatureAction;
    }

    public Request getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(Request httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setRequestBodySerializer(RequestBodySerializer requestBodySerializer) {
        this.requestBodySerializer = requestBodySerializer;
    }

    public RequestBodySerializer getRequestBodySerializer() {
        return this.requestBodySerializer;
    }
}

