/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.assist.Range;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.response.serializer.body.ResponseFilePartSerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseFileSerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import java.io.File;
import java.util.Map;

public class GetObjectRequest
extends CosXmlRequest {
    private String rspContentType;
    private String rspContentLanguage;
    private String rspExpires;
    private String rspCacheControl;
    private String rspContentDisposition;
    private String rspContentEncoding;
    private String cosPath;
    private Range range;
    private QCloudProgressListener progressListener;
    private String savePath;

    public GetObjectRequest(String savePath) {
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.savePath = savePath;
    }

    public void build() {
        ResponseFileSerializer responseFileSerializer;
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            for (Map.Entry entry : this.requestQueryParams.entrySet()) {
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.responseSerializer = new HttpPassAllSerializer();
        if (this.range != null) {
            responseFileSerializer = new ResponseFilePartSerializer(this.getDownloadPath(), this.range, GetObjectResult.class);
            responseFileSerializer.setProgressListener(this.progressListener);
            this.responseBodySerializer = responseFileSerializer;
        } else {
            responseFileSerializer = new ResponseFileSerializer(this.getDownloadPath(), GetObjectResult.class);
            responseFileSerializer.setProgressListener(this.progressListener);
            this.responseBodySerializer = responseFileSerializer;
        }
    }

    @Override
    protected void setRequestQueryParams() {
        if (this.rspContentType != null) {
            this.requestQueryParams.put("response-content-type", this.rspContentType);
        }
        if (this.rspContentLanguage != null) {
            this.requestQueryParams.put("response-content-language", this.rspContentLanguage);
        }
        if (this.rspExpires != null) {
            this.requestQueryParams.put("response-expires", this.rspExpires);
        }
        if (this.rspCacheControl != null) {
            this.requestQueryParams.put("response-cache-control", this.rspCacheControl);
        }
        if (this.rspContentDisposition != null) {
            this.requestQueryParams.put("response-content-dispositio", this.rspContentDisposition);
        }
        if (this.rspContentEncoding != null) {
            this.requestQueryParams.put("response-content-encoding", this.rspContentEncoding);
        }
    }

    @Override
    public void checkParameters() throws QCloudException {
        if (this.bucket == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new QCloudException(QCloudExceptionType.REQUEST_PARAMETER_INCORRECT, "cosPath must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "GET";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setRspContentType(String rspContentType) {
        this.rspContentType = rspContentType;
    }

    public String getRspContentType() {
        return this.rspContentType;
    }

    public void setRspContentLanguage(String rspContentLanguage) {
        this.rspContentLanguage = rspContentLanguage;
    }

    public String getRspContentLanguage() {
        return this.rspContentLanguage;
    }

    public void setRspExpires(String rspExpires) {
        this.rspExpires = rspExpires;
    }

    public String getRspExpires() {
        return this.rspExpires;
    }

    public void setRspCacheControl(String rspCacheControl) {
        this.rspCacheControl = rspCacheControl;
    }

    public String getRspCacheControl() {
        return this.rspCacheControl;
    }

    public void setRspContentDispositon(String rspContentDispositon) {
        this.rspContentDisposition = rspContentDispositon;
    }

    public String getRspContentDispositon() {
        return this.rspContentDisposition;
    }

    public void setRspContentEncoding(String rspContentEncoding) {
        this.rspContentEncoding = rspContentEncoding;
    }

    public String getRspContentEncoding() {
        return this.rspContentEncoding;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setRange(long start, long end) {
        if (start < 0L) {
            start = 0L;
        }
        Range range = new Range(start, end);
        this.requestHeaders.put("Range", range.toString());
        this.range = range;
    }

    public void setRange(long start) {
        if (start < 0L) {
            start = 0L;
        }
        Range range = new Range(start);
        this.requestHeaders.put("Range", range.toString());
        this.range = range;
    }

    public Range getRange() {
        return this.range;
    }

    public void setIfModifiedSince(String ifModifiedSince) {
        if (ifModifiedSince != null) {
            this.requestHeaders.put("If-Modified-Since", ifModifiedSince);
        }
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public String getSavePath() {
        return this.savePath;
    }

    protected String getDownloadPath() {
        String path = null;
        if (this.savePath != null && this.cosPath != null) {
            int separator;
            path = !this.savePath.endsWith("/") ? this.savePath + "/" : this.savePath;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            path = (separator = this.cosPath.lastIndexOf("/")) >= 0 ? path + this.cosPath.substring(separator + 1) : path + this.cosPath;
        }
        return path;
    }
}

