/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.CosXmlResultListener;
import com.tencent.cos.xml.model.bucket.DeleteBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketCORSResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketTaggingRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketTaggingResult;
import com.tencent.cos.xml.model.bucket.GetBucketACLRequest;
import com.tencent.cos.xml.model.bucket.GetBucketACLResult;
import com.tencent.cos.xml.model.bucket.GetBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.GetBucketCORSResult;
import com.tencent.cos.xml.model.bucket.GetBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.GetBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.GetBucketLocationRequest;
import com.tencent.cos.xml.model.bucket.GetBucketLocationResult;
import com.tencent.cos.xml.model.bucket.GetBucketRequest;
import com.tencent.cos.xml.model.bucket.GetBucketResult;
import com.tencent.cos.xml.model.bucket.GetBucketTaggingRequest;
import com.tencent.cos.xml.model.bucket.GetBucketTaggingResult;
import com.tencent.cos.xml.model.bucket.HeadBucketRequest;
import com.tencent.cos.xml.model.bucket.HeadBucketResult;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsRequest;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsResult;
import com.tencent.cos.xml.model.bucket.PutBucketACLRequest;
import com.tencent.cos.xml.model.bucket.PutBucketACLResult;
import com.tencent.cos.xml.model.bucket.PutBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.PutBucketCORSResult;
import com.tencent.cos.xml.model.bucket.PutBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.PutBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.PutBucketRequest;
import com.tencent.cos.xml.model.bucket.PutBucketResult;
import com.tencent.cos.xml.model.bucket.PutBucketTaggingRequest;
import com.tencent.cos.xml.model.bucket.PutBucketTaggingResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.AbortMultiUploadResult;
import com.tencent.cos.xml.model.object.AppendObjectRequest;
import com.tencent.cos.xml.model.object.AppendObjectResult;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.DeleteMultiObjectRequest;
import com.tencent.cos.xml.model.object.DeleteMultiObjectResult;
import com.tencent.cos.xml.model.object.DeleteObjectRequest;
import com.tencent.cos.xml.model.object.DeleteObjectResult;
import com.tencent.cos.xml.model.object.GetObjectACLRequest;
import com.tencent.cos.xml.model.object.GetObjectACLResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.OptionObjectRequest;
import com.tencent.cos.xml.model.object.OptionObjectResult;
import com.tencent.cos.xml.model.object.PutObjectACLRequest;
import com.tencent.cos.xml.model.object.PutObjectACLResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.service.GetServiceRequest;
import com.tencent.cos.xml.model.service.GetServiceResult;
import com.tencent.cos.xml.model.tag.COSXMLError;
import com.tencent.cos.xml.sign.CosXmlCredentialProvider;
import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.QCloudResult;
import com.tencent.qcloud.network.QCloudResultListener;
import com.tencent.qcloud.network.QCloudService;
import com.tencent.qcloud.network.QCloudServiceConfig;
import com.tencent.qcloud.network.auth.QCloudCredentialProvider;
import com.tencent.qcloud.network.exception.QCloudException;

public class CosXmlService
extends QCloudService {
    public CosXmlService(Context context, CosXmlServiceConfig serviceConfig, CosXmlCredentialProvider cloudCredentialProvider) {
        super(context, (QCloudServiceConfig)serviceConfig, (QCloudCredentialProvider)cloudCredentialProvider);
    }

    public GetServiceResult getService(GetServiceRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetServiceResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getServiceAsync(GetServiceRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetServiceResult(), cosXmlResultListener);
    }

    public AbortMultiUploadResult abortMultiUpload(AbortMultiUploadRequest request) throws QCloudException {
        this.buildRequest(request);
        return (AbortMultiUploadResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void abortMultiUploadAsync(AbortMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new AbortMultiUploadResult(), cosXmlResultListener);
    }

    public AppendObjectResult appendObject(AppendObjectRequest request) throws QCloudException {
        this.buildRequest(request);
        AppendObjectResult appendObjectResult = (AppendObjectResult)this.requestManager.send((QCloudHttpRequest)request);
        this.generateAccessUrl(request, appendObjectResult);
        return appendObjectResult;
    }

    public void appendObjectAsync(AppendObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new AppendObjectResult(), cosXmlResultListener);
    }

    public CompleteMultiUploadResult completeMultiUpload(CompleteMultiUploadRequest request) throws QCloudException {
        this.buildRequest(request);
        CompleteMultiUploadResult completeMultiUploadResult = (CompleteMultiUploadResult)this.requestManager.send((QCloudHttpRequest)request);
        this.generateAccessUrl(request, completeMultiUploadResult);
        return completeMultiUploadResult;
    }

    public void completeMultiUploadAsync(CompleteMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new CompleteMultiUploadResult(), cosXmlResultListener);
    }

    public DeleteMultiObjectResult deleteMultiObject(DeleteMultiObjectRequest request) throws QCloudException {
        this.buildRequest(request);
        return (DeleteMultiObjectResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void deleteMultiObjectAsync(DeleteMultiObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new DeleteMultiObjectResult(), cosXmlResultListener);
    }

    public DeleteObjectResult deleteObject(DeleteObjectRequest request) throws QCloudException {
        this.buildRequest(request);
        return (DeleteObjectResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void deleteObjectAsync(DeleteObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new DeleteObjectResult(), cosXmlResultListener);
    }

    public GetObjectACLResult getObjectACL(GetObjectACLRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetObjectACLResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getObjectACLAsync(GetObjectACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetObjectACLResult(), cosXmlResultListener);
    }

    public GetObjectResult getObject(GetObjectRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetObjectResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getObjectAsync(GetObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetObjectResult(), cosXmlResultListener);
    }

    public HeadObjectResult headObject(HeadObjectRequest request) throws QCloudException {
        this.buildRequest(request);
        return (HeadObjectResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void headObjectAsync(HeadObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new HeadObjectResult(), cosXmlResultListener);
    }

    public InitMultipartUploadResult initMultipartUpload(InitMultipartUploadRequest request) throws QCloudException {
        this.buildRequest(request);
        return (InitMultipartUploadResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void initMultipartUploadAsync(InitMultipartUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new InitMultipartUploadResult(), cosXmlResultListener);
    }

    public ListPartsResult listParts(ListPartsRequest request) throws QCloudException {
        this.buildRequest(request);
        return (ListPartsResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void listPartsAsync(ListPartsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new ListPartsResult(), cosXmlResultListener);
    }

    public OptionObjectResult optionObject(OptionObjectRequest request) throws QCloudException {
        this.buildRequest(request);
        return (OptionObjectResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void optionObjectAsync(OptionObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new OptionObjectResult(), cosXmlResultListener);
    }

    public PutObjectACLResult putObjectACL(PutObjectACLRequest request) throws QCloudException {
        this.buildRequest(request);
        return (PutObjectACLResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void putObjectACLAsync(PutObjectACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new PutObjectACLResult(), cosXmlResultListener);
    }

    public PutObjectResult putObject(PutObjectRequest request) throws QCloudException {
        this.buildRequest(request);
        PutObjectResult putObjectResult = (PutObjectResult)this.requestManager.send((QCloudHttpRequest)request);
        this.generateAccessUrl(request, putObjectResult);
        return putObjectResult;
    }

    public void putObjectAsync(PutObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new PutObjectResult(), cosXmlResultListener);
    }

    public UploadPartResult uploadPart(UploadPartRequest request) throws QCloudException {
        this.buildRequest(request);
        return (UploadPartResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void uploadPartAsync(UploadPartRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new UploadPartResult(), cosXmlResultListener);
    }

    public DeleteBucketCORSResult deleteBucketCORS(DeleteBucketCORSRequest request) throws QCloudException {
        this.buildRequest(request);
        return (DeleteBucketCORSResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void deleteBucketCORSAsync(DeleteBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new DeleteBucketCORSResult(), cosXmlResultListener);
    }

    public DeleteBucketLifecycleResult deleteBucketLifecycle(DeleteBucketLifecycleRequest request) throws QCloudException {
        this.buildRequest(request);
        return (DeleteBucketLifecycleResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void deleteBucketLifecycleAsync(DeleteBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new DeleteBucketLifecycleResult(), cosXmlResultListener);
    }

    public DeleteBucketResult deleteBucket(DeleteBucketRequest request) throws QCloudException {
        this.buildRequest(request);
        return (DeleteBucketResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void deleteBucketAsync(DeleteBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new DeleteBucketResult(), cosXmlResultListener);
    }

    public DeleteBucketTaggingResult deleteBucketTagging(DeleteBucketTaggingRequest request) throws QCloudException {
        this.buildRequest(request);
        return (DeleteBucketTaggingResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void deleteBucketTaggingAsync(DeleteBucketTaggingRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new DeleteBucketTaggingResult(), cosXmlResultListener);
    }

    public GetBucketACLResult getBucketACL(GetBucketACLRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetBucketACLResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getBucketACLAsync(GetBucketACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetBucketACLResult(), cosXmlResultListener);
    }

    public GetBucketCORSResult getBucketCORS(GetBucketCORSRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetBucketCORSResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getBucketCORSAsync(GetBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetBucketCORSResult(), cosXmlResultListener);
    }

    public GetBucketLifecycleResult getBucketLifecycle(GetBucketLifecycleRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetBucketLifecycleResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getBucketLifecycleAsync(GetBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetBucketLifecycleResult(), cosXmlResultListener);
    }

    public GetBucketLocationResult getBucketLocation(GetBucketLocationRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetBucketLocationResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getBucketLocationAsync(GetBucketLocationRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetBucketLocationResult(), cosXmlResultListener);
    }

    public GetBucketResult getBucket(GetBucketRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetBucketResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getBucketAsync(GetBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetBucketResult(), cosXmlResultListener);
    }

    public GetBucketTaggingResult getBucketTagging(GetBucketTaggingRequest request) throws QCloudException {
        this.buildRequest(request);
        return (GetBucketTaggingResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void getBucketTaggingAsync(GetBucketTaggingRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new GetBucketTaggingResult(), cosXmlResultListener);
    }

    public HeadBucketResult headBucket(HeadBucketRequest request) throws QCloudException {
        this.buildRequest(request);
        return (HeadBucketResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void headBucketAsync(HeadBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new HeadBucketResult(), cosXmlResultListener);
    }

    public ListMultiUploadsResult listMultiUploads(ListMultiUploadsRequest request) throws QCloudException {
        this.buildRequest(request);
        return (ListMultiUploadsResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void listMultiUploadsAsync(ListMultiUploadsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new ListMultiUploadsResult(), cosXmlResultListener);
    }

    public PutBucketACLResult putBucketACL(PutBucketACLRequest request) throws QCloudException {
        this.buildRequest(request);
        return (PutBucketACLResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void putBucketACLAsync(PutBucketACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new PutBucketACLResult(), cosXmlResultListener);
    }

    public PutBucketCORSResult putBucketCORS(PutBucketCORSRequest request) throws QCloudException {
        this.buildRequest(request);
        return (PutBucketCORSResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void putBucketCORSAsync(PutBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new PutBucketCORSResult(), cosXmlResultListener);
    }

    public PutBucketLifecycleResult putBucketLifecycle(PutBucketLifecycleRequest request) throws QCloudException {
        this.buildRequest(request);
        return (PutBucketLifecycleResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void putBucketLifecycleAsync(PutBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new PutBucketLifecycleResult(), cosXmlResultListener);
    }

    public PutBucketResult putBucket(PutBucketRequest request) throws QCloudException {
        this.buildRequest(request);
        return (PutBucketResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void putBucketAsync(PutBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new PutBucketResult(), cosXmlResultListener);
    }

    public PutBucketTaggingResult putBucketTagging(PutBucketTaggingRequest request) throws QCloudException {
        this.buildRequest(request);
        return (PutBucketTaggingResult)this.requestManager.send((QCloudHttpRequest)request);
    }

    public void putBucketTaggingAsync(PutBucketTaggingRequest request, CosXmlResultListener cosXmlResultListener) {
        this.requestSend(request, new PutBucketTaggingResult(), cosXmlResultListener);
    }

    public boolean cancel(CosXmlRequest cosXmlRequest) {
        return this.requestManager.cancel((QCloudHttpRequest)cosXmlRequest);
    }

    public void cancelAll() {
        this.requestManager.cancelAll();
    }

    public void release() {
        this.requestManager.release();
    }

    protected void buildRequest(QCloudHttpRequest cosRequest) throws QCloudException {
        CosXmlRequest cosXmlRequest = (CosXmlRequest)cosRequest;
        cosXmlRequest.checkParameters();
        super.buildRequest(cosRequest);
    }

    private void getResultByException(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult, QCloudException qcloudException, CosXmlResultListener cosXmlResultListener) {
        if (qcloudException != null) {
            if (cosXmlResult != null && cosXmlResultListener != null) {
                cosXmlResult.setHttpCode(2500 + qcloudException.getExceptionType().getCode());
                cosXmlResult.setHttpMessage("exception");
                cosXmlResult.error = new COSXMLError();
                cosXmlResult.error.code = qcloudException.getExceptionType().getMessage();
                cosXmlResult.error.message = qcloudException.getDetailMessage();
                cosXmlResult.error.traceId = "check exception message";
                cosXmlResult.error.requestId = "check exception message";
                if (cosXmlRequest != null) {
                    cosXmlResult.error.resource = cosXmlRequest.getBucket();
                }
                cosXmlResultListener.onFail(cosXmlRequest, cosXmlResult);
            } else {
                qcloudException.printStackTrace();
            }
        }
    }

    private void getResultByQCloudResult(CosXmlRequest cosXmlRequest, QCloudResult qCloudResult, CosXmlResultListener cosXmlResultListener) {
        if (qCloudResult != null && cosXmlResultListener != null) {
            if (qCloudResult.getHttpCode() >= 300 || qCloudResult.getHttpCode() < 200) {
                cosXmlResultListener.onFail(cosXmlRequest, (CosXmlResult)qCloudResult);
            } else {
                if (cosXmlRequest instanceof AppendObjectRequest || cosXmlRequest instanceof PutObjectRequest || cosXmlRequest instanceof CompleteMultiUploadRequest) {
                    this.generateAccessUrl(cosXmlRequest, (CosXmlResult)qCloudResult);
                }
                cosXmlResultListener.onSuccess(cosXmlRequest, (CosXmlResult)qCloudResult);
            }
        }
    }

    private void requestSend(final CosXmlRequest cosXmlRequest, final CosXmlResult cosXmlResult, final CosXmlResultListener cosXmlResultListener) {
        try {
            this.buildRequest(cosXmlRequest);
        }
        catch (QCloudException e) {
            this.getResultByException(cosXmlRequest, cosXmlResult, e, cosXmlResultListener);
            return;
        }
        this.requestManager.send((QCloudHttpRequest)cosXmlRequest, new QCloudResultListener(){

            public void onSuccess(QCloudRequest request, QCloudResult result) {
                CosXmlService.this.getResultByQCloudResult(cosXmlRequest, result, cosXmlResultListener);
            }

            public void onFail(QCloudRequest request, QCloudException exception) {
                CosXmlService.this.getResultByException(cosXmlRequest, cosXmlResult, exception, cosXmlResultListener);
            }
        });
    }

    private void generateAccessUrl(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
        if (cosXmlRequest == null || cosXmlResult == null) {
            return;
        }
        if (cosXmlResult.getHttpCode() >= 200 && cosXmlResult.getHttpCode() < 300) {
            StringBuilder accessUrl = new StringBuilder();
            QCloudServiceConfig qCloudServiceConfig = this.getServiceConfig();
            if (qCloudServiceConfig != null) {
                accessUrl.append(qCloudServiceConfig.getHttpProtocol()).append("://").append(cosXmlRequest.getBucket()).append(qCloudServiceConfig.getHttpHost()).append(cosXmlRequest.getRequestPath());
            }
            cosXmlResult.accessUrl = accessUrl.toString();
        }
    }
}

