/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.parse.Builder;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelistBuilder
implements Builder<Changelist> {
    private static final Logger logger = Logger.getLogger(ChangelistBuilder.class);

    @Override
    public String[] getBuildCmd(String id) {
        return new String[]{"p4", "describe", "-s", id};
    }

    @Override
    public Changelist build(StringBuilder sb) throws PerforceException {
        Changelist change = null;
        StringTokenizer lines = new StringTokenizer(sb.toString(), "\t\n\r");
        try {
            while (lines.hasMoreElements()) {
                String line = lines.nextToken();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Line: " + line));
                }
                if (line.startsWith("Change")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"New changelist.");
                    }
                    change = new Changelist();
                    StringTokenizer details = new StringTokenizer(line);
                    details.nextToken();
                    change.setChangeNumber(new Integer(details.nextToken()));
                    details.nextToken();
                    String user = details.nextToken();
                    change.setUser(user.substring(0, user.indexOf("@")));
                    change.setWorkspace(user.substring(user.indexOf("@") + 1));
                    details.nextToken();
                    String date = details.nextToken();
                    String time = details.nextToken();
                    change.setDate(ChangelistBuilder.parseDate(date + " " + time));
                    StringBuilder desc = new StringBuilder();
                    line = lines.nextToken();
                    while (line != null && !line.startsWith("Affected files") && !line.startsWith("Jobs fixed")) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Description Line: " + line));
                        }
                        desc.append(line + "\n");
                        line = lines.nextToken();
                    }
                    change.setDescription(desc.toString().trim());
                }
                if (line.startsWith("Jobs fixed")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Has jobs.");
                    }
                    ArrayList<Changelist.JobEntry> jobs = new ArrayList<Changelist.JobEntry>();
                    boolean getDesc = false;
                    Changelist.JobEntry job = new Changelist.JobEntry();
                    String description = null;
                    do {
                        line = lines.nextToken();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Job Line: " + line));
                        }
                        if (!getDesc) {
                            StringTokenizer details = new StringTokenizer(line);
                            job = new Changelist.JobEntry();
                            job.setJob(details.nextToken());
                            try {
                                details.nextToken();
                                details.nextToken();
                                details.nextToken();
                                details.nextToken();
                                job.setStatus(details.nextToken());
                            }
                            catch (NoSuchElementException ignore) {
                                job.setStatus("status_unknown");
                            }
                            description = "";
                            getDesc = true;
                            continue;
                        }
                        while (!line.startsWith("Affected files")) {
                            description = description + line;
                            if (!lines.hasMoreElements()) break;
                            description = description + "\n";
                            line = lines.nextToken();
                        }
                        job.setDescription(description.trim());
                        jobs.add(job);
                        getDesc = false;
                    } while (!line.startsWith("Affected files"));
                    change.setJobs(jobs);
                }
                if (!line.startsWith("Affected files")) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"reading files...");
                }
                ArrayList<Changelist.FileEntry> files = new ArrayList<Changelist.FileEntry>();
                while (lines.hasMoreElements()) {
                    int revStart;
                    String entry = lines.nextToken();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("File Line: " + entry));
                    }
                    if ((revStart = entry.indexOf("#")) < 0) continue;
                    String filename = entry.substring(4, revStart);
                    String rev = entry.substring(revStart + 1, entry.indexOf(" ", revStart));
                    String action = this.interpretAction(entry.substring(entry.indexOf(" ", revStart) + 1));
                    Changelist.FileEntry file = new Changelist.FileEntry();
                    file.setFilename(filename);
                    file.setRevision(rev);
                    file.setAction(Changelist.FileEntry.Action.valueOf(action.toUpperCase(Locale.US)));
                    files.add(file);
                }
                change.setFiles(files);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception: " + e.getMessage()));
            throw new PerforceException("Failed to retrieve changelist.", e);
        }
        return change;
    }

    private String interpretAction(String action) {
        if (action == null) {
            return null;
        }
        if (action.contains("/")) {
            return action.replace('/', '_');
        }
        return action;
    }

    @Override
    public String[] getSaveCmd() {
        return new String[]{"p4", "change", "-i"};
    }

    @Override
    public void save(Changelist obj, Writer out) throws PerforceException {
        throw new UnsupportedOperationException("This is not implemented.");
    }

    public static Date parseDate(String newDate) {
        if (newDate == null || newDate.equals("")) {
            return null;
        }
        String[] parts = newDate.split(" ");
        String[] date = parts[0].split("/");
        String[] time = null;
        if (parts.length > 1) {
            time = parts[1].split(":");
            time[2] = time[2].replaceAll("\\.0", "");
        } else {
            time = "00:00:00".split(":");
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.clear();
        cal.set(new Integer(date[0]), new Integer(date[1]) - 1, new Integer(date[2]), new Integer(time[0]), new Integer(time[1]), new Integer(time[2]));
        return cal.getTime();
    }
}

