/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.parse.Builder;
import com.tek42.perforce.process.Executor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPerforceTemplate {
    private static final String[] RESPONSE_MESSAGES = new String[]{"Connect to server failed; check $P4PORT", "Perforce password (P4PASSWD) invalid or unset.", "Password not allowed at this server security level, use 'p4 login'", "Your session has expired, please login again.", "Can't create a new user - over license quota.", "Access for user '", "Request too large ", "Unknown command.  Try 'p4 help' for info.", "is opened and not being changed", "Can't clobber writable file"};
    Depot depot;
    Logger logger;

    public AbstractPerforceTemplate(Depot depot) {
        this.depot = depot;
        this.logger = depot.getLogger();
    }

    protected List<String> parseList(StringBuilder response, int index) {
        StringTokenizer lines = new StringTokenizer(response.toString(), "\n\r");
        ArrayList<String> list = new ArrayList<String>(100);
        while (lines.hasMoreElements()) {
            String line = lines.nextToken();
            StringTokenizer columns = new StringTokenizer(line);
            for (int column = 0; column < index; ++column) {
                if (!columns.hasMoreTokens()) {
                    this.logger.warn((Object)("Invalid line found in output, skipping:  " + line));
                    break;
                }
                columns.nextToken();
            }
            if (columns.hasMoreTokens()) {
                list.add(columns.nextToken());
                continue;
            }
            this.logger.warn((Object)("Invalid line found in output, skipping:  " + line));
        }
        return list;
    }

    protected String[] getExtraParams(String[] cmd) {
        String ticket = this.depot.getP4Ticket();
        if (ticket != null) {
            String[] newCmds = new String[cmd.length + 2];
            newCmds[0] = "p4";
            newCmds[1] = "-P";
            newCmds[2] = ticket;
            int i = 3;
            while (i - 2 < cmd.length) {
                newCmds[i] = cmd[i - 2];
                ++i;
            }
            cmd = newCmds;
        }
        return cmd;
    }

    protected void saveToPerforce(Object object, Builder builder) throws PerforceException {
        Executor p4 = this.depot.getExecFactory().newExecutor();
        try {
            String line;
            String[] cmds = this.getExtraParams(builder.getSaveCmd());
            StringBuilder debugCmd = new StringBuilder();
            for (String cm : cmds) {
                debugCmd.append(cm).append(" ");
            }
            p4.exec(this.depot.getExecutable(), cmds);
            BufferedReader reader = p4.getReader();
            BufferedWriter writer = p4.getWriter();
            final StringBuilder log = new StringBuilder();
            FilterWriter fwriter = new FilterWriter(writer){

                public void write(String str) throws IOException {
                    log.append(str);
                    this.out.write(str);
                }
            };
            builder.save(object, fwriter);
            ((Writer)fwriter).flush();
            ((Writer)fwriter).close();
            String error = "";
            String info = "";
            int exitCode = 0;
            while ((line = reader.readLine()) != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("LineIn -> " + line));
                }
                if (line.startsWith("error")) {
                    if (line.trim().equals("") || line.indexOf("up-to-date") >= 0 || line.indexOf("no file(s) to resolve") >= 0) continue;
                    error = error + line.substring(6);
                    continue;
                }
                if (line.startsWith("exit")) {
                    exitCode = new Integer(line.substring(line.indexOf(" ") + 1, line.length()));
                    continue;
                }
                if (line.contains(":")) {
                    info = info + line.substring(line.indexOf(":"));
                    continue;
                }
                info = info + line;
            }
            reader.close();
            if (exitCode != 0) {
                if (!error.equals("")) {
                    throw new PerforceException(error + "\nFor Command: " + debugCmd + "\nWith Data:\n===================\n" + log.toString() + "===================\n");
                }
                throw new PerforceException(info);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)info);
            }
        }
        catch (IOException e) {
            throw new PerforceException("Failed to open connection to perforce", e);
        }
        finally {
            p4.close();
        }
    }

    protected StringBuilder getPerforceResponse(String[] cmd) throws PerforceException {
        return this.getPerforceResponse(cmd, false);
    }

    protected StringBuilder getPerforceResponse(String[] cmd, boolean ignoreResponse) throws PerforceException {
        boolean loop = false;
        boolean attemptLogin = true;
        StringBuilder response = new StringBuilder();
        do {
            int mesgIndex = -1;
            int count = 0;
            Executor p4 = this.depot.getExecFactory().newExecutor();
            try {
                String line;
                cmd = this.getExtraParams(cmd);
                p4.exec(this.depot.getExecutable(), cmd);
                BufferedReader reader = p4.getReader();
                response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    ++count;
                    for (int i = 0; i < RESPONSE_MESSAGES.length; ++i) {
                        if (!line.contains(RESPONSE_MESSAGES[i])) continue;
                        mesgIndex = i;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)line);
                    }
                    if (ignoreResponse) continue;
                    response.append(line).append("\n");
                }
                loop = false;
                if (attemptLogin && (mesgIndex == 1 || mesgIndex == 2 || mesgIndex == 3)) {
                    p4.close();
                    this.login();
                    loop = true;
                    attemptLogin = false;
                } else {
                    if (mesgIndex == 5) {
                        throw new PerforceException("Access for user '" + this.depot.getUser() + "' has not been enabled by 'p4 protect'");
                    }
                    if (mesgIndex == 6) {
                        throw new PerforceException("Request too large; see 'p4 help maxresults'");
                    }
                    if (mesgIndex == 7) {
                        throw new PerforceException(RESPONSE_MESSAGES[mesgIndex] + " It is possible you are using a version of Perforce that is not supported.");
                    }
                    if (mesgIndex == 8) {
                        throw new PerforceException("There are files in the source that are open for edit.  Could not complete command.");
                    }
                    if (mesgIndex == 9) {
                        throw new PerforceException(RESPONSE_MESSAGES[mesgIndex] + ". Could not complete command.");
                    }
                    if (mesgIndex != -1) {
                        throw new PerforceException(RESPONSE_MESSAGES[mesgIndex]);
                    }
                    if (count == 0) {
                        StringBuffer debugCmd = new StringBuffer();
                        for (String cm : cmd) {
                            debugCmd.append(cm).append(" ");
                        }
                        throw new PerforceException("No output for: " + debugCmd.toString());
                    }
                }
            }
            catch (IOException e) {
                throw new PerforceException("Failed to communicate with p4", e);
            }
            finally {
                p4.close();
            }
        } while (loop);
        return response;
    }

    protected void login() throws PerforceException {
        String sep = System.getProperty("file.separator");
        if (sep.equals("\\")) {
            Executor login = this.depot.getExecFactory().newExecutor();
            login.exec(this.depot.getExecutable(), new String[]{"p4", "login"});
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                login.getWriter().write(this.depot.getPassword() + "\n");
            }
            catch (IOException e) {
                throw new PerforceException("Failed to communicate with p4 when logging in to server.");
            }
            login.close();
        } else {
            Executor login = this.depot.getExecFactory().newExecutor();
            Object[] args = new String[]{"/bin/sh", "-c", this.depot.getExecutable() + " login -p"};
            this.logger.info((Object)("Running " + Arrays.toString(args)));
            login.exec(null, (String[])args);
            String ticket = null;
            try {
                String line;
                login.getWriter().write(this.depot.getPassword() == null ? "" : this.depot.getPassword());
                login.getWriter().newLine();
                login.getWriter().flush();
                BufferedReader reader = login.getReader();
                while ((line = reader.readLine()) != null) {
                    ticket = line;
                }
                if (ticket != null && (ticket = ticket.trim()).contains(" ")) {
                    throw new PerforceException("Failed to login: " + ticket);
                }
            }
            catch (IOException e) {
                throw new PerforceException("Unable to login via p4 login due to IOException: " + e.getMessage());
            }
            if (ticket != null) {
                this.logger.warn((Object)"Using p4 issued ticket.");
                this.depot.setP4Ticket(ticket);
            }
            login.close();
        }
    }
}

