package com.tek42.perforce.process;

import com.tek42.perforce.PerforceException;
import org.apache.log4j.Logger;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Executes on the command line. This is not thread safe.
 *
 * @author Mike Wille
 */
public class CmdLineExecutor implements Executor {
	ProcessBuilder builder;
	Process currentProcess;
	List<String> args;
	BufferedWriter writer;
	BufferedReader reader;
    private static final Logger logger = Logger.getLogger(CmdLineExecutor.class);

	/**
	 * Requires a map of environment variables (P4USER, P4CLIENT, P4PORT, etc)
	 *
	 * @param environment
	 */
	public CmdLineExecutor(Map<String, String> environment) {
		args = new ArrayList<String>();
		builder = new ProcessBuilder(args);
        Map<String, String> env = builder.environment();
		for(Map.Entry<String, String> entry : environment.entrySet()) {
			// if(key.equals("P4PASSWD"))
			// continue;
			// logger.warn("Settin env: " + key + " = " + environment.get(key));
			env.put(entry.getKey(), entry.getValue());
		}
	}

    public CmdLineExecutor(Map<String, String> environment, File runningDirectory)
    {
        this(environment);
        if (builder != null)
        {
            builder.directory(runningDirectory);
        }
    }

    /*
      * (non-Javadoc)
      *
      * @see com.tek42.perforce.process.P4Executor#exec(java.lang.String[])
      */
    public void exec(String exe, String[] args) throws PerforceException
    {
        this.args.clear();

        // Check to ensure that p4 is running in the correct directory
        if ("p4".equals(args[0]) && exe != null)
        {
            args[0] = exe;
        }

        this.args.addAll(Arrays.asList(args));

        if (logger.isDebugEnabled())
        {
            final StringBuilder debug = new StringBuilder();

            for (String arg : args)
            {
                debug.append(arg).append(" ");
            }

            // check if command is trying to log in.
            if (debug.toString().contains(" login "))
            {
                logger.debug("Attempting to login to Perforce...");
            }
            else
            {
                logger.debug("Executing: " + debug);
            }

            // log the directory the command will be running in
            if (builder.directory() != null)
            {
                logger.debug("In directory: " + builder.directory());
            }
        }

        builder.redirectErrorStream(true);
        //builder = builder.directory(new File("/Users/brydie/dev/tools/perforce/"));
        try
        {
            currentProcess = builder.start();
            reader = new BufferedReader(new InputStreamReader(currentProcess.getInputStream()));
            writer = new BufferedWriter(new OutputStreamWriter(currentProcess.getOutputStream()));

        }
        catch (IOException e)
        {
            throw new PerforceException("Failed to open connection to: " + args[0], e);
        }
    }

    /*
      * (non-Javadoc)
      *
      * @see com.tek42.perforce.process.P4Executor#getReader()
      */
    public BufferedReader getReader()
    {
        return reader;
    }

    /*
      * (non-Javadoc)
      *
      * @see com.tek42.perforce.process.P4Executor#getWriter()
      */
    public BufferedWriter getWriter()
    {
        return writer;
    }

    /*
      * (non-Javadoc)
      *
      * @see com.tek42.perforce.process.P4Executor#close()
      */
    public void close()
    {
        try
        {
            if (reader != null)
            {
                reader.close();
            }
            reader = null;
        }
        catch (IOException e)
        {
        }

        try
        {
            if (writer != null)
            {
                writer.close();
            }
            writer = null;
        }
        catch (IOException e)
        {
        }
    }

    /**
     * Useful for things like process.waitFor().
     *
     * @return
     */
    public Process getProcess()
    {
        return currentProcess;
    }

}
