package com.tek42.perforce.parse;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.Depot;
import com.tek42.perforce.model.User;

import java.util.List;

/**
 * Base API object for interacting with users.
 * 
 * @author Mike Wille
 */
public class Users extends AbstractPerforceTemplate {
	public Users(Depot depot) {
		super(depot);
	}

	/**
	 * Returns the user specified by username.
	 * 
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public User getUser(String name) throws Exception {
		UserBuilder builder = new UserBuilder();
		User user = builder.build(getPerforceResponse(builder.getBuildCmd(name)));
		return user;
	}

    public List<String> getUserList() throws PerforceException
    {
        String[] cmd = {"p4", "users"};
        StringBuilder response = getPerforceResponse(cmd);

        List<String> users = parseList(response, 0);

        return users;
    }
}
