/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Cacheable;
import com.perforce.api.CommitException;
import com.perforce.api.Env;
import com.perforce.api.HashDecay;
import com.perforce.api.PerforceException;
import java.util.Date;

public abstract class SourceControlObject
implements Cacheable {
    private long update_time = 0L;
    private long sync_time = 0L;
    private Env environ;

    public SourceControlObject() {
    }

    public SourceControlObject(Env env) {
        this();
        this.setEnv(env);
    }

    public void setEnv(Env env) {
        this.environ = env;
    }

    public Env getEnv() {
        return this.environ;
    }

    @Override
    public synchronized long getUpdateTime() {
        return this.update_time;
    }

    @Override
    public synchronized void refreshUpdateTime() {
        this.update_time = new Date().getTime();
    }

    @Override
    public synchronized long getSyncTime() {
        return this.sync_time;
    }

    @Override
    public synchronized boolean outOfSync(long threshold) {
        return threshold < new Date().getTime() - this.sync_time;
    }

    @Override
    public synchronized void invalidate() {
        this.sync_time = 0L;
    }

    @Override
    public synchronized void inSync() {
        this.sync_time = new Date().getTime();
    }

    @Override
    public void clearCache() {
        this.getCache().clear();
    }

    @Override
    public abstract HashDecay getCache();

    @Override
    public abstract void commit() throws CommitException;

    @Override
    public abstract void sync() throws PerforceException;

    public abstract String toXML();
}

