/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Change;
import com.perforce.api.CommitException;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.FileEntry;
import com.perforce.api.HashDecay;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.SourceControlObject;
import com.perforce.api.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Job
extends SourceControlObject {
    private String name = "new";
    private String user = null;
    private String modtime_string = "";
    private String description = "\tUseless description. This must be changed.";
    private int status = 1;
    private Hashtable fields = new Hashtable();
    private static HashDecay jobs = new HashDecay();
    private Change[] changes = null;
    public static final int OPEN = 1;
    public static final int CLOSED = 2;
    public static final int SUSPENDED = 4;

    public Job(Env env) {
        if (null == this.fields) {
            this.fields = new Hashtable();
        }
        this.getCache();
        this.setEnv(env);
    }

    private static HashDecay setCache() {
        if (null == jobs) {
            jobs = new HashDecay(300000L);
            jobs.start();
        }
        return jobs;
    }

    @Override
    public HashDecay getCache() {
        return Job.setCache();
    }

    public Job(String name) {
        this((Env)null);
        this.name = name;
    }

    public Job() {
        this((Env)null);
    }

    public Job(Env env, String name) {
        this(env);
        this.name = name;
    }

    public static Job getJob(String name) {
        return Job.getJob(null, name);
    }

    public static Job getJob(Env env, String name) {
        Job j = new Job(name);
        if (null != env) {
            j.setEnv(env);
        }
        j.sync();
        return j;
    }

    public String getModtimeString() {
        return this.modtime_string;
    }

    public void setModtimeString(String modtime) {
        this.modtime_string = modtime;
    }

    public void setName(String name) {
        this.name = name;
        this.user = null;
        this.description = "";
        this.status = 1;
    }

    public String getName() {
        return this.name;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setDescription(String description) {
        try {
            String l;
            StringBuffer sb = new StringBuffer();
            BufferedReader b = new BufferedReader(new StringReader(description));
            while (null != (l = b.readLine())) {
                sb.append('\t');
                sb.append(l.trim());
                sb.append('\n');
            }
            this.description = sb.toString();
        }
        catch (IOException ex) {
            this.description = description;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Enumeration getFieldNames() {
        return this.fields.keys();
    }

    public void setField(String name, String value) {
        this.fields.put(name.toLowerCase(), value);
    }

    public String getField(String name) {
        return (String)this.fields.get(name.toLowerCase());
    }

    public Vector getFileEntries() {
        Vector<FileEntry> v = new Vector<FileEntry>();
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        this.changes = this.getChanges();
        for (int i = 0; i < this.changes.length; ++i) {
            this.changes[i].sync();
            Enumeration en = this.changes[i].getFileEntries().elements();
            while (en.hasMoreElements()) {
                FileEntry fent = (FileEntry)en.nextElement();
                Integer pos = (Integer)h.get(fent.getDepotPath());
                if (null != pos) {
                    if (((FileEntry)v.elementAt(pos)).getHeadRev() >= fent.getHeadRev()) continue;
                    v.setElementAt(fent, pos);
                    continue;
                }
                v.addElement(fent);
                h.put(fent.getDepotPath(), new Integer(v.size() - 1));
            }
        }
        return v;
    }

    public void setStatus(String status) {
        this.status = -1 != status.indexOf("closed") ? 2 : (-1 != status.indexOf("suspended") ? 4 : 1);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusName() {
        switch (this.status) {
            case 4: {
                return "suspended";
            }
            case 2: {
                return "closed";
            }
        }
        return "open";
    }

    public void store() throws CommitException {
        this.commit();
    }

    @Override
    public void commit() throws CommitException {
        StringBuffer sb = new StringBuffer();
        String[] cmd = new String[]{"p4", "job", "-i"};
        boolean store_failed = false;
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            p.println("Job: " + this.getName());
            p.println("Status: " + this.getStatusName());
            if (null == this.getUser() && null != this.getEnv()) {
                p.println("User: " + this.getEnv().getUser());
            } else {
                p.println("User: " + this.user);
            }
            p.println("Description: ");
            p.println(this.getDescription());
            Enumeration en = this.fields.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                p.println(key + ": " + (String)this.fields.get(key));
            }
            p.flush();
            p.outClose();
            while (null != (l = p.readLine())) {
                int pos;
                if (l.startsWith("Job ") && -1 != (pos = l.indexOf("saved"))) {
                    this.setName(l.substring(4, pos - 1).trim());
                }
                if (l.startsWith("Error")) {
                    store_failed = true;
                }
                sb.append(l);
                sb.append('\n');
            }
            p.close();
        }
        catch (Exception ex) {
            throw new CommitException(ex.getMessage());
        }
        if (store_failed) {
            throw new CommitException(sb.toString());
        }
    }

    @Override
    public void sync() {
        this.sync(this.name);
    }

    public void sync(String name) {
        this.name = name;
        String[] cmd = new String[]{"p4", "job", "-o", "jobname"};
        cmd[3] = name;
        String tmpdesc = "";
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            p.setRawMode(true);
            while (null != (l = p.readLine())) {
                if (!l.startsWith("info: ") || (l = l.substring(6)).startsWith("#")) continue;
                if (l.startsWith("Job:")) {
                    name = l.substring(4).trim();
                    continue;
                }
                if (l.startsWith("Status:")) {
                    this.setStatus(l.substring(8).trim());
                    continue;
                }
                if (l.startsWith("ReportedBy:")) {
                    this.user = l.substring(11).trim();
                    continue;
                }
                if (l.startsWith("ReportedDate:")) {
                    this.modtime_string = l.substring(14).trim();
                    continue;
                }
                if (l.startsWith("Description:")) {
                    while (null != (l = p.readLine()) && l.startsWith("info: \t")) {
                        tmpdesc = tmpdesc + l.substring(6).trim() + "\n";
                    }
                    this.setDescription(tmpdesc);
                    continue;
                }
                int pos = l.indexOf(58);
                if (-1 == pos) continue;
                this.setField(l.substring(0, pos).trim(), l.substring(pos + 1).trim());
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
    }

    public static void fix(Env env, String changelist, boolean del, String job) {
        Vector<String> jobs = new Vector<String>();
        jobs.addElement(job);
        Job.fix(env, changelist, del, jobs);
    }

    public static void fix(Env env, String changelist, boolean del, Vector jobs) {
        if (null == jobs) {
            return;
        }
        int i = 0;
        int len = del ? 5 : 4;
        String[] cmd = new String[len += jobs.size()];
        cmd[i++] = "p4";
        cmd[i++] = "fix";
        cmd[i++] = "-c";
        cmd[i++] = changelist;
        if (del) {
            cmd[i++] = "-d";
        }
        Enumeration en = jobs.elements();
        while (en.hasMoreElements()) {
            cmd[i++] = (String)en.nextElement();
        }
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
    }

    public void removeFix(int changelist) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Job: ");
        sb.append(this.name);
        sb.append("\nUser: ");
        sb.append(this.user);
        sb.append("\nDescription:\n");
        sb.append(this.description);
        return sb.toString();
    }

    public static Job[] getJobs(Env env) {
        return Job.getJobs(env, null, 0, false, null);
    }

    public static Job[] getJobs(Env env, String jobview, int max, boolean use_integs, String[] files) {
        int args = 3;
        int pos = 0;
        if (null != jobview) {
            args += 2;
        }
        if (use_integs) {
            ++args;
        }
        if (0 < max) {
            args += 2;
        }
        if (null != files) {
            args += files.length;
        }
        String[] cmd = new String[args];
        cmd[pos++] = "p4";
        cmd[pos++] = "jobs";
        cmd[pos++] = "-l";
        if (null != jobview) {
            cmd[pos++] = "-e";
            cmd[pos++] = jobview;
        }
        if (use_integs) {
            cmd[pos++] = "-i";
        }
        if (0 < max) {
            cmd[pos++] = "-m";
            cmd[pos++] = String.valueOf(max);
        }
        if (null != files) {
            for (int i = 0; i < files.length; ++i) {
                cmd[pos++] = files[i];
            }
        }
        Vector<Job> v = new Vector<Job>();
        Job j = null;
        String tmpdesc = "";
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            p.setRawMode(true);
            while (null != (l = p.readLine())) {
                if (l.startsWith("info: \t")) {
                    tmpdesc = tmpdesc + l.substring(7) + "\n";
                    continue;
                }
                if (l.trim().equals("info:")) continue;
                if (null != j) {
                    j.setDescription(tmpdesc);
                    v.addElement(j);
                }
                tmpdesc = "";
                j = null;
                StringTokenizer st = new StringTokenizer(l);
                if (2 > st.countTokens()) continue;
                st.nextToken();
                String name = st.nextToken();
                if (!st.nextToken().equals("on")) continue;
                String modtime = st.nextToken();
                if (!st.nextToken().equals("by")) continue;
                String user = st.nextToken();
                String state = st.nextToken();
                j = new Job(env, name);
                j.setModtimeString(modtime);
                j.setStatus(state);
                j.setUser(user);
            }
            p.close();
            if (null != j) {
                j.setDescription(tmpdesc);
                v.addElement(j);
            }
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
        Job[] jobs = new Job[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            jobs[i] = (Job)v.elementAt(i);
        }
        return jobs;
    }

    public Change[] getChanges() {
        if (null == this.changes) {
            this.changes = Job.getChangeFixes(this.getEnv(), this.getName(), null);
        }
        return this.changes;
    }

    public static Change[] getChangeFixes(Env env, String jobname, String[] files) {
        Vector[] fixes = Job.getFixes(env, jobname, null, files);
        Vector vc = fixes[0];
        Change[] changes = new Change[vc.size()];
        for (int i = 0; i < vc.size(); ++i) {
            changes[i] = (Change)vc.elementAt(i);
        }
        return changes;
    }

    public static Job[] getJobFixes(Env env, String change, String[] files) {
        Vector[] fixes = Job.getFixes(env, null, change, files);
        Vector vj = fixes[1];
        Job[] jobs = new Job[vj.size()];
        for (int i = 0; i < vj.size(); ++i) {
            jobs[i] = (Job)vj.elementAt(i);
        }
        return jobs;
    }

    private static Vector[] getFixes(Env env, String jobname, String change, String[] files) {
        int args = 2;
        int pos = 0;
        if (null != jobname) {
            args += 2;
            jobname = jobname.trim();
        }
        if (null != change) {
            args += 2;
            change = change.trim();
        }
        if (null != files) {
            args += files.length;
        }
        String[] cmd = new String[args];
        cmd[pos++] = "p4";
        cmd[pos++] = "fixes";
        if (null != jobname) {
            cmd[pos++] = "-j";
            cmd[pos++] = jobname;
        }
        if (null != change) {
            cmd[pos++] = "-c";
            cmd[pos++] = change;
        }
        if (null != files) {
            for (int i = 0; i < files.length; ++i) {
                cmd[pos++] = files[i];
            }
        }
        Vector<Change> vc = new Vector<Change>();
        Vector<Job> vj = new Vector<Job>();
        Change c = null;
        Job jb = null;
        String tmpdesc = "";
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                StringTokenizer st = new StringTokenizer(l);
                String jbname = st.nextToken();
                jb = new Job(env, jbname);
                vj.addElement(jb);
                if (!st.nextToken().equals("fixed") || !st.nextToken().equals("by") || !st.nextToken().equals("change")) continue;
                c = new Change(st.nextToken());
                c.setEnv(env);
                if (!st.nextToken().equals("on")) continue;
                c.setModtimeString(st.nextToken());
                if (!st.nextToken().equals("by")) continue;
                c.setClientName(st.nextToken());
                if (null == c) continue;
                vc.addElement(c);
                c = null;
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
        Vector[] fixes = new Vector[]{vc, vj};
        return fixes;
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer("<job name=\"");
        sb.append(this.getName());
        sb.append("\" user=\"");
        sb.append(this.getUser());
        sb.append("\" status=\"");
        sb.append(this.getStatusName());
        sb.append("\" modtime=\"");
        sb.append(this.getModtimeString());
        sb.append("\"><description>");
        sb.append(this.getDescription());
        sb.append("<description>");
        Enumeration en = this.fields.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            sb.append("<field name=\"");
            sb.append(key);
            sb.append("\" value=\"");
            sb.append((String)this.fields.get(key));
            sb.append("\"/>");
        }
        sb.append("</job>");
        return sb.toString();
    }

    public static void main(String[] args) {
        String propfile = "/etc/p4.conf";
        Env environ = null;
        if (0 < args.length) {
            propfile = args[0];
        }
        try {
            environ = new Env(propfile);
        }
        catch (PerforceException ex) {
            System.out.println("Could not load properties from " + propfile + ": " + ex);
            System.exit(-1);
        }
        System.out.println(environ);
        Job[] jobs = Job.getJobs(environ);
        for (int i = 0; i < jobs.length; ++i) {
            System.out.println(jobs[i].getName() + " [" + jobs[i].getUser() + "]:\n\n" + jobs[i].getDescription());
        }
        System.out.println("\n---------\n");
        Job j = Job.getJob(environ, "job000002");
        System.out.println(j.getName() + " [" + j.getUser() + "]:\n\n" + j.getDescription());
        System.out.println("\n---------\n");
        System.out.println("Job " + j.getName() + " fixes:");
        Change[] chngs = j.getChanges();
        for (int x = 0; x < chngs.length; ++x) {
            System.out.println("\t change #" + chngs[x].getNumber());
        }
        if (0 < chngs.length) {
            System.out.println("\n---------\n");
            System.out.println("Change " + chngs[0].getNumber() + " is fixed by:");
            Job[] jfixes = Job.getJobFixes(environ, String.valueOf(chngs[0].getNumber()), null);
            for (int x = 0; x < jfixes.length; ++x) {
                System.out.println("\t job " + jfixes[x].getName());
            }
        }
        Utils.cleanUp();
    }
}

