package com.alibaba.weex.plugin.loader.utils;

import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.IWXDebugAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapterFactory;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.ui.WXComponentRegistry;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.DEBUG_ADAPTER;
import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.DRAWABLE_LOADER;
import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.HTTP_ADAPTER;
import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.IMG_LOADER_ADAPTER;
import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.JS_EXCEPTION_ADAPTER;
import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.STORAGE_ADAPTER;
import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.URI_ADAPTER;
import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.USER_TRACK_ADAPTER;
import static com.alibaba.weex.plugin.loader.utils.WeexSDKUtil.WeexAdapters.WEBSOCKET_ADAPTER_FACTORY;

/**
 * Created by moxun on 17/3/14.
 */

public final class WeexSDKUtil {
    public final static boolean containsModule(String name, boolean global) {
        if ("dom".equals(name)) {
            return true;
        }

        if (global) {
            try {
                Field sGlobalModuleMap = WXModuleManager.class.getDeclaredField("sGlobalModuleMap");
                sGlobalModuleMap.setAccessible(true);
                Object field = sGlobalModuleMap.get(null);
                if (field == null) {
                    return false;
                }

                if (field instanceof Map) {
                    Map globalModuleMap = (Map) field;
                    return globalModuleMap.containsKey(name);
                }
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Field sModuleFactoryMap = WXModuleManager.class.getDeclaredField("sModuleFactoryMap");
                sModuleFactoryMap.setAccessible(true);
                Object field = sModuleFactoryMap.get(null);
                if (field == null) {
                    return false;
                }

                if (field instanceof Map) {
                    Map moduleMap = (Map) field;
                    return moduleMap.containsKey(name);
                }
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        return false;
    }

    public final static boolean containsComponent(List<String> names) {
        for (String name : names) {
            if (WXComponentRegistry.getComponent(name) != null) {
                return true;
            }
        }
        return false;
    }

    public final static boolean containsAdapter(String adapterClassName) {
        WXSDKManager wxsdkManager = WXSDKManager.getInstance();
        String fieldName = adapters.get(adapterClassName);
        return isNull(wxsdkManager, fieldName);
    }

    public final static boolean isValidAdapterType(String adapterClassName) {
        return adapters.containsKey(adapterClassName);
    }

    public final static String getAdapterField(String adapterClassName) {
        return adapters.get(adapterClassName);
    }

    public final static boolean isNull(Object object, String fieldName) {
        if (fieldName == null) {
            return false;
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(object);
            return value == null;
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public final static boolean containsDomObject(String name) {
        return false;
    }

    private final static Map<String, String> adapters = new HashMap<String, String>(9);

    static {
        adapters.put(HTTP_ADAPTER, "mIWXHttpAdapter");
        adapters.put(DRAWABLE_LOADER, "mDrawableLoader");
        adapters.put(IMG_LOADER_ADAPTER, "mIWXImgLoaderAdapter");
        adapters.put(USER_TRACK_ADAPTER, "mIWXUserTrackAdapter");
        adapters.put(DEBUG_ADAPTER, "mIWXDebugAdapter");
        adapters.put(STORAGE_ADAPTER, "mIWXStorageAdapter");
        adapters.put(URI_ADAPTER, "mURIAdapter");
        adapters.put(WEBSOCKET_ADAPTER_FACTORY, "mIWebSocketAdapterFactory");
        adapters.put(JS_EXCEPTION_ADAPTER, "mIWXJSExceptionAdapter");
    }

    interface WeexAdapters {
        String HTTP_ADAPTER = IWXHttpAdapter.class.getCanonicalName();
        String DRAWABLE_LOADER = IDrawableLoader.class.getCanonicalName();
        String IMG_LOADER_ADAPTER = IWXImgLoaderAdapter.class.getCanonicalName();
        String USER_TRACK_ADAPTER = IWXUserTrackAdapter.class.getCanonicalName();
        String DEBUG_ADAPTER = IWXDebugAdapter.class.getCanonicalName();
        String STORAGE_ADAPTER = IWXStorageAdapter.class.getCanonicalName();
        String URI_ADAPTER = URIAdapter.class.getCanonicalName();
        String WEBSOCKET_ADAPTER_FACTORY = IWebSocketAdapterFactory.class.getCanonicalName();
        String JS_EXCEPTION_ADAPTER = IWXJSExceptionAdapter.class.getCanonicalName();
    }
}
