/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.Scroller;
import com.taobao.weex.ui.view.listview.IRefreshLayout;

public abstract class BaseBounceView<T extends View>
extends ViewGroup {
    private static final float FRICTION = 2.0f;
    private static final int DEFAULT_DURATION = 250;
    private int mTouchSlop;
    private boolean mIsBeingDragged;
    private float mLastMotionY;
    private float mLastMotionX;
    private Mode mMode;
    protected Scroller mScroller;
    private T mView;
    private IRefreshLayout mRefreshLayout;
    private IRefreshLayout mLoadMoreLayout;
    private int mScrollValue = 0;
    private int mMaxPadding = 0;
    private GestureDetectorCompat mGestureDetector;
    private boolean mBounceable = true;
    private final GestureDetector.SimpleOnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            BaseBounceView.this.mScroller.fling(BaseBounceView.this.getPaddingLeft(), BaseBounceView.this.getPaddingTop(), 0, (int)velocityY, 0, 0, -BaseBounceView.this.mMaxPadding, 0);
            BaseBounceView.this.invalidate();
            return true;
        }
    };

    public BaseBounceView(Context context) {
        this(context, null);
    }

    public BaseBounceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        ViewConfiguration config = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = config.getScaledTouchSlop();
        this.mScroller = new Scroller(context);
        this.mView = this.createBounceView(context);
        this.addView((View)this.mView, -1, -1);
        this.mRefreshLayout = this.createBounceHeaderView(context);
        if (this.mRefreshLayout != null) {
            this.addView(this.mRefreshLayout.getView(), -1, -2);
        }
        this.mLoadMoreLayout = this.createBounceFooterView(context);
        if (this.mLoadMoreLayout != null) {
            this.addView(this.mLoadMoreLayout.getView(), -1, -2);
        }
    }

    public final T getBounceView() {
        return this.mView;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action != 0 && this.mIsBeingDragged) {
            return true;
        }
        switch (action) {
            case 0: {
                this.mLastMotionY = ev.getRawY();
                this.mLastMotionX = ev.getRawX();
                this.mScrollValue = -this.getPaddingTop();
                break;
            }
            case 2: {
                float x = ev.getRawX();
                float y = ev.getRawY();
                float deltaX = ev.getRawX() - this.mLastMotionX;
                float deltaY = ev.getRawY() - this.mLastMotionY;
                float degree = Math.abs(deltaY) / Math.abs(deltaX);
                if (!(Math.abs(deltaY) > (float)this.mTouchSlop) || !(degree >= 1.7f) || !this.mBounceable) break;
                if (deltaY > 0.0f && this.isReadyForPullFromTop()) {
                    this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    this.mIsBeingDragged = true;
                    this.mMode = Mode.PULL_FROM_TOP;
                    break;
                }
                if (!(deltaY < 0.0f) || !this.isReadyForPullFromBottom()) break;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                this.mIsBeingDragged = true;
                this.mMode = Mode.PULL_FROM_BOTTOM;
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mGestureDetector != null) {
            this.mGestureDetector.onTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                if (ev.getEdgeFlags() != 0) {
                    return false;
                }
                this.mLastMotionX = ev.getRawX();
                this.mLastMotionY = ev.getRawY();
                this.mScrollValue = -this.getPaddingTop();
                return this.mIsBeingDragged;
            }
            case 2: {
                if (!this.mIsBeingDragged) break;
                float y = ev.getRawY();
                this.startPull(y);
                return true;
            }
            case 1: 
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.mScrollValue = -this.getPaddingTop();
                this.mIsBeingDragged = false;
                this.onTouchActionUp();
                if (this.mMaxPadding > 0) {
                    if (this.getPaddingTop() > 0) {
                        this.mScrollValue = this.getPaddingTop() > 0 ? 0 : -this.mMaxPadding;
                        this.backToInitPos(this.getPaddingTop(), this.getPaddingTop() > 0 ? -this.getPaddingTop() : -this.mMaxPadding - this.getPaddingTop());
                    }
                } else {
                    this.backToInitPos(this.getScrollY(), -this.getScrollY());
                }
                this.mMode = null;
                return true;
            }
        }
        return false;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (this.mMaxPadding > 0) {
                this.mScrollValue = -y;
                this.setPadding(x, y, 0, 0);
            } else {
                this.scrollTo(x, y);
            }
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child2;
        View child1;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        View child0 = this.getChildAt(0);
        int w = 0;
        if (child0 != null) {
            child0.measure(widthMeasureSpec, heightMeasureSpec);
            w = child0.getMeasuredWidth();
        }
        if ((child1 = this.getChildAt(1)) != null) {
            ViewGroup.LayoutParams lp = child1.getLayoutParams();
            child1.measure(View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)(lp.height > 0 ? 0x40000000 : Integer.MIN_VALUE)));
        }
        if ((child2 = this.getChildAt(2)) != null) {
            ViewGroup.LayoutParams lp = child2.getLayoutParams();
            child2.measure(View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)(lp.height > 0 ? 0x40000000 : Integer.MIN_VALUE)));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View child2;
        View child1;
        View child0 = this.getChildAt(0);
        if (child0 != null) {
            child0.layout(0, this.getPaddingTop(), r, b);
        }
        if ((child1 = this.getChildAt(1)) != null) {
            int h = child1.getMeasuredHeight();
            child1.layout(0, -h, r, 0);
        }
        if ((child2 = this.getChildAt(2)) != null) {
            int h = child2.getMeasuredHeight();
            child2.layout(0, b, r, b + h);
        }
    }

    protected void smoothScroll(int value) {
        this.mScroller.startScroll(0, this.getScrollY(), 0, value);
        this.invalidate();
    }

    public void setBounceable(boolean bounceable) {
        this.mBounceable = bounceable;
    }

    public void setEffectMaxHeight(int padding) {
        this.mMaxPadding = padding;
        if (this.mGestureDetector == null) {
            this.mGestureDetector = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)this.mGestureListener);
        }
    }

    private void startPull(float y) {
        int scrollValue = 0;
        float lastY = this.mLastMotionY;
        switch (this.mMode) {
            case PULL_FROM_TOP: {
                scrollValue = Math.round(Math.min(lastY - y, 0.0f) / 2.0f);
                break;
            }
            case PULL_FROM_BOTTOM: {
                scrollValue = Math.round(Math.max(lastY - y, 0.0f) / 2.0f);
            }
        }
        this.pullScrollTo(this.mScrollValue + scrollValue);
    }

    private void pullScrollTo(int scrollValue) {
        int maxScroll = this.getMaximumPullScroll();
        scrollValue = Math.min(maxScroll, Math.max(-maxScroll, scrollValue));
        if (this.mMaxPadding > 0) {
            this.setPadding(0, -scrollValue <= -this.mMaxPadding ? -this.mMaxPadding : -scrollValue, 0, 0);
        } else {
            this.scrollTo(0, scrollValue);
        }
        this.onPull(scrollValue);
    }

    private void onPull(int scrollValue) {
        IRefreshLayout pullLayout = null;
        switch (this.mMode) {
            case PULL_FROM_TOP: {
                pullLayout = this.mRefreshLayout;
                break;
            }
            case PULL_FROM_BOTTOM: {
                pullLayout = this.mLoadMoreLayout;
            }
        }
        if ((this.mMode == Mode.PULL_FROM_TOP || this.mMode == Mode.PULL_FROM_BOTTOM) && pullLayout != null) {
            int itemDimension = pullLayout.getView().getHeight();
            float scaleOfLayout = (float)Math.abs(scrollValue) / (float)itemDimension;
            float angle = scaleOfLayout * 90.0f;
            pullLayout.onPull(angle);
            this.onPullStateChanged(itemDimension, scrollValue);
        }
    }

    private void backToInitPos(int startY, int deltaY) {
        int duration = 250;
        if (this.mRefreshLayout != null) {
            int limit;
            int scrollLen = Math.abs(this.getScrollY());
            duration = scrollLen < (limit = this.mRefreshLayout.getView().getHeight()) ? 250 : (scrollLen - limit) * 250 / (this.getMaximumPullScroll() - limit);
        }
        this.mScroller.startScroll(0, startY, 0, deltaY, duration);
        this.invalidate();
    }

    private int getMaximumPullScroll() {
        return Math.round((float)this.getResources().getDisplayMetrics().heightPixels / 2.0f);
    }

    protected IRefreshLayout getBounceHeaderView() {
        return this.mRefreshLayout;
    }

    protected IRefreshLayout getBounceFooterView() {
        return this.mLoadMoreLayout;
    }

    public void setBounceHeaderView(IRefreshLayout layout) {
        this.mRefreshLayout = layout;
        if (this.mRefreshLayout != null && this.getChildCount() > 1) {
            this.removeViewAt(1);
            this.addView(this.mRefreshLayout.getView(), 1);
        }
    }

    public void setBounceFooterView(IRefreshLayout layout) {
        this.mLoadMoreLayout = layout;
        if (this.mLoadMoreLayout != null && this.getChildCount() > 2) {
            this.removeViewAt(2);
            this.addView(this.mLoadMoreLayout.getView(), 2);
        }
    }

    public abstract boolean isReadyForPullFromTop();

    public abstract boolean isReadyForPullFromBottom();

    public abstract T createBounceView(Context var1);

    public abstract IRefreshLayout createBounceHeaderView(Context var1);

    public IRefreshLayout createBounceFooterView(Context context) {
        return null;
    }

    protected void onPullStateChanged(int itemDimension, int scrollValue) {
    }

    protected void onTouchActionUp() {
    }

    static enum Mode {
        PULL_FROM_TOP,
        PULL_FROM_BOTTOM;

    }
}

