/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXSmoothScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.Field;

@SuppressLint(value={"HandlerLeak"})
public class WXCircleViewPager
extends ViewPager
implements Handler.Callback,
WXGestureObservable {
    private WXGesture wxGesture;
    private Handler mCircleHandler;
    private WXCircleViewPager mViewPager;
    private boolean isAutoScroll;
    private boolean isPause;
    private long intervalTime = 3000L;
    private WXSmoothScroller mScroller;

    @SuppressLint(value={"NewApi"})
    public WXCircleViewPager(Context context) {
        super(context);
        this.initView();
        this.setOverScrollMode(2);
        this.postInitViewPager();
    }

    private void initView() {
        this.mViewPager = this;
        this.mCircleHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    private void postInitViewPager() {
        if (this.isInEditMode()) {
            return;
        }
        try {
            Field scroller = ViewPager.class.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            Field interpolator = ViewPager.class.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            this.mScroller = new WXSmoothScroller(this.getContext(), (Interpolator)interpolator.get(null));
            scroller.set(this, (Object)this.mScroller);
        }
        catch (Exception e) {
            WXLogUtils.e("[CircleViewPager] postInitViewPager: " + WXLogUtils.getStackTrace(e));
        }
    }

    @SuppressLint(value={"NewApi"})
    public WXCircleViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
        this.setOverScrollMode(2);
        this.postInitViewPager();
    }

    public boolean handleMessage(Message msg) {
        if (this.isAutoScroll && !this.isPause) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
            this.mCircleHandler.removeCallbacksAndMessages(null);
            this.mCircleHandler.sendEmptyMessageDelayed(0, this.intervalTime);
        }
        return true;
    }

    public int getCurrentItem() {
        return super.getCurrentItem();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean result = super.onTouchEvent(ev);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, ev);
        }
        return result;
    }

    public void startAutoScroll() {
        this.isAutoScroll = true;
        this.mCircleHandler.sendEmptyMessageDelayed(0, this.intervalTime);
    }

    public void stopAutoScroll() {
        this.isAutoScroll = false;
        this.mCircleHandler.removeCallbacksAndMessages(null);
    }

    public int getRealCurrentItem() {
        return this.getCurrentItem() % this.getCirclePageAdapter().getRealCount();
    }

    public void setRealCurrentItem(int realItem) {
        this.setCurrentItem(realItem);
    }

    public WXCirclePageAdapter getCirclePageAdapter() {
        return (WXCirclePageAdapter)this.getAdapter();
    }

    public void setCirclePageAdapter(WXCirclePageAdapter circlePageAdapter) {
        this.setAdapter(circlePageAdapter);
    }

    public long getIntervalTime() {
        return this.intervalTime;
    }

    public void setIntervalTime(long intervalTime) {
        this.intervalTime = intervalTime;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.isPause = true;
            if (this.mCircleHandler != null) {
                this.mCircleHandler.removeCallbacksAndMessages(null);
            }
        } else if (ev.getAction() == 3) {
            this.isPause = false;
            if (this.mCircleHandler != null) {
                this.mCircleHandler.sendEmptyMessageDelayed(0, this.intervalTime);
            }
        } else if (ev.getAction() == 1) {
            this.isPause = false;
            if (this.mCircleHandler != null) {
                this.mCircleHandler.sendEmptyMessageDelayed(0, this.intervalTime);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void destory() {
        if (this.mCircleHandler != null) {
            this.mCircleHandler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }
}

