/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.List;

public class WXCirclePageAdapter
extends PagerAdapter {
    private int realCount;
    private List<View> views;

    public WXCirclePageAdapter(List<View> views) {
        this.views = views;
        this.realCount = views.size();
    }

    public WXCirclePageAdapter() {
        this.views = new ArrayList<View>();
        this.realCount = 0;
    }

    public void addPageView(View view) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>> addPageView");
        }
        if (this.views == null) {
            this.views = new ArrayList<View>();
        }
        this.views.add(view);
        this.realCount = this.views.size();
    }

    public void removePageView(View view) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>> removePageView");
        }
        if (this.views == null) {
            this.views = new ArrayList<View>();
        }
        this.views.remove(view);
        this.realCount = this.views.size();
    }

    public void replacePageView(View oldView, View newView) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>> replacePageView");
        }
        if (this.views == null) {
            this.views = new ArrayList<View>();
        }
        int index = this.views.indexOf(oldView);
        this.views.remove(index);
        this.views.add(index, newView);
        this.realCount = this.views.size();
    }

    public int getCount() {
        if (this.getRealCount() > 1) {
            return Integer.MAX_VALUE;
        }
        return this.getRealCount();
    }

    public int getRealCount() {
        return this.realCount;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View pageView = null;
        try {
            pageView = this.views.get(position % this.getRealCount());
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("onPageSelected >>>> instantiateItem >>>>> position:" + position + ",position % getRealCount()" + position % this.getRealCount());
            }
            if (pageView.getParent() == null) {
                container.addView(pageView);
            } else {
                ((ViewGroup)pageView.getParent()).removeView(pageView);
                container.addView(pageView);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[CirclePageAdapter] instantiateItem: " + WXLogUtils.getStackTrace(e));
        }
        return pageView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>> destroyItem >>>>> position:" + position);
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }
}

