/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;
import java.util.Map;

public class WXSlider
extends WXVContainer
implements ViewPager.OnPageChangeListener {
    Map<String, Object> params = new HashMap<String, Object>();
    private WXCircleViewPager mViewPager;
    private WXIndicator mIndicator;
    private WXCirclePageAdapter mAdapter;
    private FrameLayout mRoot;
    private boolean mShowIndicators;

    public WXSlider(WXSDKInstance instance, WXDomObject node, WXVContainer parent, String instanceId, boolean lazy) {
        super(instance, node, parent, instanceId, lazy);
    }

    @Override
    protected void initView() {
        this.mRoot = new FrameLayout(this.mContext);
        FrameLayout.LayoutParams pagerParams = new FrameLayout.LayoutParams(-1, -1);
        this.mViewPager = new WXCircleViewPager(this.mContext);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)pagerParams);
        this.mAdapter = new WXCirclePageAdapter();
        this.mViewPager.setAdapter(this.mAdapter);
        this.mRoot.addView((View)this.mViewPager);
        this.mHost = this.mRoot;
        this.mViewPager.setOnPageChangeListener(this);
        this.registerActivityStateListener();
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (this.getRealView() != null) {
            this.getRealView().setOnTouchListener(null);
        }
        this.mGestureType.clear();
    }

    @Override
    public ViewGroup getRealView() {
        return this.mViewPager;
    }

    @Override
    protected void addSubView(View view, int index) {
        if (view == null || this.mAdapter == null) {
            return;
        }
        if (view instanceof WXCircleIndicator) {
            return;
        }
        this.mAdapter.addPageView(view);
        this.mAdapter.notifyDataSetChanged();
        if (this.mIndicator != null) {
            this.mIndicator.getView().forceLayout();
            this.mIndicator.getView().requestLayout();
        }
    }

    @Override
    public void remove(WXComponent child) {
        if (child == null || child.getView() == null || this.mAdapter == null) {
            return;
        }
        this.mAdapter.removePageView(child.getView());
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
            this.mViewPager.removeAllViews();
            this.mViewPager.destory();
        }
    }

    @Override
    public void onActivityResume() {
        if (this.mViewPager != null) {
            this.mViewPager.startAutoScroll();
        }
    }

    @Override
    public void onActivityStop() {
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
        }
    }

    public void addIndicator(WXIndicator indicator) {
        this.mIndicator = indicator;
        this.mIndicator.getView().setCircleViewPager(this.mViewPager);
        this.mIndicator.getView().setOnPageChangeListener(this);
        this.mRoot.addView((View)this.mIndicator.getView());
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(String autoPlay) {
        if (TextUtils.isEmpty((CharSequence)autoPlay) || autoPlay.equals("false")) {
            this.mViewPager.stopAutoScroll();
        } else {
            this.mViewPager.stopAutoScroll();
            this.mViewPager.startAutoScroll();
        }
    }

    @WXComponentProp(name="showIndicators")
    public void setShowIndicators(String show) {
        this.mShowIndicators = !TextUtils.isEmpty((CharSequence)show) && !show.equals("false");
        if (this.mIndicator == null) {
            return;
        }
        this.mIndicator.setShowIndicators(this.mShowIndicators);
    }

    public void onPageScrolled(int arg0, float arg1, int arg2) {
    }

    public void onPageSelected(int pos) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>>" + pos);
        }
        if (this.mAdapter == null || this.mAdapter.getRealCount() == 0) {
            return;
        }
        int realPosition = pos % this.mAdapter.getRealCount();
        if (this.mChildren == null || realPosition >= this.mChildren.size()) {
            return;
        }
        if (this.getDomObject().event == null || this.getDomObject().event.size() == 0) {
            return;
        }
        WXEvent event = this.getDomObject().event;
        String ref = this.getDomObject().ref;
        if (event.contains("change") && WXViewUtils.onScreenArea(this.mHost)) {
            this.params.put("index", realPosition);
            WXSDKManager.getInstance().fireEvent(this.mInstanceId, ref, "change", this.params);
        }
    }

    public void onPageScrollStateChanged(int arg0) {
    }
}

