/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class WXComponentPropCache {
    private static Map<Class<? extends WXComponent>, HashMap<String, Method>> sComponentPropSetterMethod = new HashMap<Class<? extends WXComponent>, HashMap<String, Method>>();
    private static Map<Method, Type[]> sMethodGenericParameterTypes = new HashMap<Method, Type[]>();

    public static HashMap<String, Method> getMethods(Class<? extends WXComponent> clazz) {
        HashMap<String, Method> methodMap = sComponentPropSetterMethod.get(clazz);
        if (methodMap != null) {
            return methodMap;
        }
        methodMap = new HashMap();
        try {
            for (Method method : clazz.getMethods()) {
                for (Annotation anno : method.getDeclaredAnnotations()) {
                    if (anno == null || !(anno instanceof WXComponentProp)) continue;
                    methodMap.put(((WXComponentProp)anno).name(), method);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXComponentPropCache] getMethods: " + WXLogUtils.getStackTrace(e));
            return null;
        }
        sComponentPropSetterMethod.put(clazz, methodMap);
        return methodMap;
    }

    public static Type[] getMethodGenericParameterTypes(Method method) {
        Type[] types = sMethodGenericParameterTypes.get(method);
        try {
            if (types == null) {
                types = method.getGenericParameterTypes();
                sMethodGenericParameterTypes.put(method, types);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXComponentPropCache] getMethodGenericParameterTypes: " + WXLogUtils.getStackTrace(e));
            return null;
        }
        return types;
    }
}

