/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.module;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.utils.WXLogUtils;
import java.net.URLDecoder;
import java.util.HashMap;
import org.json.JSONObject;

public class WXModalUIModule
extends WXModule {
    private Toast toast;

    @WXModuleAnno
    public void toast(String param) {
        String message = "";
        int duration = 0;
        if (!TextUtils.isEmpty((CharSequence)param)) {
            try {
                param = URLDecoder.decode(param, "utf-8");
                JSONObject jsObj = new JSONObject(param);
                message = jsObj.optString("message");
                duration = jsObj.optInt("duration");
            }
            catch (Exception e) {
                WXLogUtils.e("[WXModalUIModule] alert param parse error " + WXLogUtils.getStackTrace(e));
            }
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            WXLogUtils.e("[WXModalUIModule] toast param parse is null ");
            return;
        }
        duration = duration > 3 ? 1 : 0;
        if (this.toast == null) {
            this.toast = Toast.makeText((Context)this.mWXSDKInstance.getContext(), (CharSequence)message, (int)duration);
        } else {
            this.toast.setDuration(duration);
            this.toast.setText((CharSequence)message);
        }
        this.toast.setGravity(17, 0, 0);
        this.toast.show();
    }

    @WXModuleAnno
    public void alert(String param, final String callbackId) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String okTitle = "ok";
            if (!TextUtils.isEmpty((CharSequence)param)) {
                try {
                    param = URLDecoder.decode(param, "utf-8");
                    JSONObject jsObj = new JSONObject(param);
                    message = jsObj.optString("message");
                    okTitle = jsObj.optString("okTitle");
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] alert param parse error " + WXLogUtils.getStackTrace(e));
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                WXLogUtils.e("[WXModalUIModule] alert param parse is null ");
                return;
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final String okTitle_f = TextUtils.isEmpty((CharSequence)okTitle) ? "ok" : okTitle;
            builder.setPositiveButton((CharSequence)okTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    WXBridgeManager.getInstance().callback(WXModalUIModule.this.mWXSDKInstance.getInstanceId(), callbackId, okTitle_f);
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
        } else {
            WXLogUtils.e("[WXModalUIModule] when call alert mWXSDKInstance.getContext() must instanceof Activity");
        }
    }

    @WXModuleAnno
    public void confirm(String param, final String callbackId) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String okTitle = "ok";
            String cancelTitle = "cancel";
            if (!TextUtils.isEmpty((CharSequence)param)) {
                try {
                    param = URLDecoder.decode(param, "utf-8");
                    JSONObject jsObj = new JSONObject(param);
                    message = jsObj.optString("message");
                    okTitle = jsObj.optString("okTitle");
                    cancelTitle = jsObj.optString("cancelTitle");
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] confirm param parse error " + WXLogUtils.getStackTrace(e));
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                WXLogUtils.e("[WXModalUIModule] confirm param parse is null ");
                return;
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final String okTitle_f = TextUtils.isEmpty((CharSequence)okTitle) ? "ok" : okTitle;
            final String cancelTitle_f = TextUtils.isEmpty((CharSequence)cancelTitle) ? "cancel" : cancelTitle;
            builder.setPositiveButton((CharSequence)okTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    WXBridgeManager.getInstance().callback(WXModalUIModule.this.mWXSDKInstance.getInstanceId(), callbackId, okTitle_f);
                }
            });
            builder.setNegativeButton((CharSequence)cancelTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    WXBridgeManager.getInstance().callback(WXModalUIModule.this.mWXSDKInstance.getInstanceId(), callbackId, cancelTitle_f);
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
        } else {
            WXLogUtils.e("[WXModalUIModule] when call confirm mWXSDKInstance.getContext() must instanceof Activity");
        }
    }

    @WXModuleAnno
    public void prompt(String param, final String callbackId) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String defaultValue = "";
            String okTitle = "ok";
            String cancelTitle = "cancel";
            if (!TextUtils.isEmpty((CharSequence)param)) {
                try {
                    param = URLDecoder.decode(param, "utf-8");
                    JSONObject jsObj = new JSONObject(param);
                    message = jsObj.optString("message");
                    okTitle = jsObj.optString("okTitle");
                    cancelTitle = jsObj.optString("cancelTitle");
                    defaultValue = jsObj.optString("default");
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] confirm param parse error " + WXLogUtils.getStackTrace(e));
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                WXLogUtils.e("[WXModalUIModule] confirm param parse is null ");
                return;
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final EditText editText = new EditText(this.mWXSDKInstance.getContext());
            editText.setText((CharSequence)defaultValue);
            builder.setView((View)editText);
            final String okTitle_f = TextUtils.isEmpty((CharSequence)okTitle) ? "ok" : okTitle;
            final String cancelTitle_f = TextUtils.isEmpty((CharSequence)cancelTitle) ? "cancel" : cancelTitle;
            builder.setPositiveButton((CharSequence)okTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("result", okTitle_f);
                    result.put("data", editText.getText().toString());
                    WXBridgeManager.getInstance().callback(WXModalUIModule.this.mWXSDKInstance.getInstanceId(), callbackId, result);
                }
            });
            builder.setNegativeButton((CharSequence)cancelTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    WXBridgeManager.getInstance().callback(WXModalUIModule.this.mWXSDKInstance.getInstanceId(), callbackId, cancelTitle_f);
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
        } else {
            WXLogUtils.e("when call prompt mWXSDKInstance.getContext() must instanceof Activity");
        }
    }
}

