/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import java.util.HashMap;
import java.util.Map;

class WXCustomStyleSpan
extends MetricAffectingSpan {
    private static final Map<String, Typeface> sTypefaceCache = new HashMap<String, Typeface>();
    private final int mStyle;
    private final int mWeight;
    private final String mFontFamily;

    public WXCustomStyleSpan(int fontStyle, int fontWeight, String fontFamily) {
        this.mStyle = fontStyle;
        this.mWeight = fontWeight;
        this.mFontFamily = fontFamily;
    }

    public void updateDrawState(TextPaint ds) {
        WXCustomStyleSpan.apply((Paint)ds, this.mStyle, this.mWeight, this.mFontFamily);
    }

    private static void apply(Paint paint, int style, int weight, String family) {
        Typeface typeface = paint.getTypeface();
        int oldStyle = typeface == null ? 0 : typeface.getStyle();
        int want = 0;
        if (weight == 1 || (oldStyle & 1) != 0 && weight == -1) {
            want |= 1;
        }
        if (style == 2 || (oldStyle & 2) != 0 && style == -1) {
            want |= 2;
        }
        if (family != null) {
            typeface = WXCustomStyleSpan.getOrCreateTypeface(family, want);
        }
        if (typeface != null) {
            paint.setTypeface(Typeface.create((Typeface)typeface, (int)want));
        } else {
            paint.setTypeface(Typeface.defaultFromStyle((int)want));
        }
    }

    private static Typeface getOrCreateTypeface(String family, int style) {
        if (sTypefaceCache.get(family) != null) {
            return sTypefaceCache.get(family);
        }
        Typeface typeface = Typeface.create((String)family, (int)style);
        sTypefaceCache.put(family, typeface);
        return typeface;
    }

    public void updateMeasureState(TextPaint paint) {
        WXCustomStyleSpan.apply((Paint)paint, this.mStyle, this.mWeight, this.mFontFamily);
    }

    public int getStyle() {
        return this.mStyle == -1 ? 0 : this.mStyle;
    }

    public int getWeight() {
        return this.mWeight == -1 ? 0 : this.mWeight;
    }

    public String getFontFamily() {
        return this.mFontFamily;
    }
}

