/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.dom.WXDomModule;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WXModuleManager {
    private static Map<String, Class<? extends WXModule>> sModuleClazzMap = new HashMap<String, Class<? extends WXModule>>();
    private static Map<String, WXModule> sGlobalModuleMap = new HashMap<String, WXModule>();
    private static Map<WXModule, HashMap<String, Method>> sGlobalModuleMethodMap = new HashMap<WXModule, HashMap<String, Method>>();
    private static Map<String, HashMap<String, WXModule>> sInstanceModuleMap = new HashMap<String, HashMap<String, WXModule>>();
    private static Map<WXModule, HashMap<String, Method>> sInstanceModuleMethodMap = new HashMap<WXModule, HashMap<String, Method>>();

    public static boolean registerModule(String moduleName, Class<? extends WXModule> moduleClass) throws WXException {
        return WXModuleManager.registerModule(moduleName, moduleClass, false);
    }

    public static boolean registerModule(String moduleName, Class<? extends WXModule> moduleClass, boolean global) throws WXException {
        if (moduleName == null || moduleClass == null) {
            return false;
        }
        if (sModuleClazzMap.containsKey(moduleName)) {
            if (WXEnvironment.isApkDebugable()) {
                throw new WXException("Duplicate the Module name:" + moduleName);
            }
            WXLogUtils.e("WXComponentRegistry Duplicate the Module name: " + moduleName);
            return false;
        }
        if (WXEnvironment.isApkDebugable()) {
            try {
                moduleClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new WXException("Module must have a default constructor");
            }
        }
        if (global) {
            try {
                WXModule wxModule = moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                sGlobalModuleMap.put(moduleName, wxModule);
                HashMap<String, Method> methodsMap = WXModuleManager.getModuleMethods2Map(moduleClass);
                sGlobalModuleMethodMap.put(wxModule, methodsMap);
            }
            catch (Exception e) {
                WXLogUtils.e(moduleClass + " class must have a default constructor without params. " + WXLogUtils.getStackTrace(e));
                return false;
            }
        }
        return WXModuleManager.registerNativeModule(moduleName, moduleClass) && WXModuleManager.registerJSModule(moduleName, moduleClass);
    }

    private static <T extends WXModule> HashMap<String, Method> getModuleMethods2Map(Class<T> moduleClass) {
        HashMap<String, Method> moduleMethods = new HashMap<String, Method>();
        try {
            for (Method method : moduleClass.getMethods()) {
                for (Annotation anno : method.getDeclaredAnnotations()) {
                    if (anno == null || !(anno instanceof WXModuleAnno) || !((WXModuleAnno)anno).moduleMethod()) continue;
                    moduleMethods.put(method.getName(), method);
                }
            }
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXModuleManager] getModuleMethods2Map:" + e.getCause());
        }
        return moduleMethods;
    }

    static <T extends WXModule> boolean registerNativeModule(String moduleName, Class<T> moduleClass) throws WXException {
        if (moduleClass == null) {
            return false;
        }
        sModuleClazzMap.put(moduleName, moduleClass);
        return true;
    }

    static <T extends WXModule> boolean registerJSModule(String moduleName, Class<T> moduleClass) {
        HashMap<String, Object> modules = new HashMap<String, Object>();
        modules.put(moduleName, WXModuleManager.getModuleMethods2Array(moduleClass));
        WXSDKManager.getInstance().registerModules(modules);
        return true;
    }

    private static <T extends WXModule> ArrayList<String> getModuleMethods2Array(Class<T> moduleClass) {
        ArrayList<String> methods = new ArrayList<String>();
        try {
            for (Method method : moduleClass.getMethods()) {
                for (Annotation anno : method.getDeclaredAnnotations()) {
                    if (anno == null || !(anno instanceof WXModuleAnno) || !((WXModuleAnno)anno).moduleMethod()) continue;
                    methods.add(method.getName());
                }
            }
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXModuleManager] getModuleMethods2Array:" + e.getStackTrace());
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args) {
        final WXModule wxModule = WXModuleManager.findModule(instanceId, moduleStr, methodStr);
        if (wxModule == null) {
            return false;
        }
        wxModule.mWXSDKInstance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        HashMap<String, Method> methodsMap = sGlobalModuleMethodMap.get(wxModule);
        HashMap<String, Method> hashMap = methodsMap = methodsMap == null ? sInstanceModuleMethodMap.get(wxModule) : methodsMap;
        if (methodsMap == null) {
            WXLogUtils.e("[WXModuleManager] callModuleMethod methodsMap is null.");
            return false;
        }
        final Method moduleMethod = methodsMap.get(methodStr);
        try {
            Type[] paramClazzs = moduleMethod.getGenericParameterTypes();
            final Object[] params = new Object[paramClazzs.length];
            for (int i = 0; i < paramClazzs.length; ++i) {
                Type paramClazz = paramClazzs[i];
                Object value = args.get(i);
                if (paramClazz == JSONObject.class) {
                    params[i] = value;
                    continue;
                }
                String sValue = value instanceof String ? (String)value : JSON.toJSONString((Object)value);
                params[i] = paramClazz == Integer.TYPE ? Integer.valueOf(Integer.parseInt(sValue)) : (paramClazz == String.class ? sValue : (paramClazz == Long.TYPE ? Long.valueOf(Long.parseLong(sValue)) : (paramClazz == Double.TYPE ? Double.valueOf(Double.parseDouble(sValue)) : (paramClazz == Float.TYPE ? Float.valueOf(Float.parseFloat(sValue)) : (ParameterizedType.class.isAssignableFrom(paramClazz.getClass()) ? JSON.parseObject((String)sValue, (Type)paramClazz, (Feature[])new Feature[0]) : (IWXObject.class.isAssignableFrom(paramClazz.getClass()) ? JSON.parseObject((String)sValue, (Type)paramClazz, (Feature[])new Feature[0]) : JSON.parseObject((String)sValue, (Type)paramClazz, (Feature[])new Feature[0])))))));
            }
            WXModuleAnno anno = moduleMethod.getAnnotation(WXModuleAnno.class);
            if (anno.runOnUIThread()) {
                WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            moduleMethod.invoke((Object)wxModule, params);
                        }
                        catch (Exception e) {
                            WXLogUtils.e("callModuleMethod >>> invoke module:" + WXLogUtils.getStackTrace(e));
                        }
                    }
                }, 0L);
            } else {
                moduleMethod.invoke((Object)wxModule, params);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("callModuleMethod >>> invoke module:" + moduleStr + ", method:" + methodStr + " failed. " + WXLogUtils.getStackTrace(e));
            boolean bl = false;
            return bl;
        }
        finally {
            if (wxModule instanceof WXDomModule) {
                wxModule.mWXSDKInstance = null;
            }
        }
        return true;
    }

    private static WXModule findModule(String instanceId, String moduleStr, String methodStr) {
        HashMap<String, Method> methodsMap;
        WXModule wxModule = sGlobalModuleMap.get(moduleStr);
        Class<? extends WXModule> moduleClass = sModuleClazzMap.get(moduleStr);
        if (wxModule == null) {
            HashMap<String, WXModule> moduleMap = sInstanceModuleMap.get(instanceId);
            if (moduleMap == null) {
                moduleMap = new HashMap();
                sInstanceModuleMap.put(instanceId, moduleMap);
            }
            if ((wxModule = moduleMap.get(moduleStr)) == null) {
                try {
                    wxModule = moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    WXLogUtils.e(moduleClass + " class must have a default constructor without params. " + WXLogUtils.getStackTrace(e));
                    return null;
                }
                moduleMap.put(moduleStr, wxModule);
                wxModule.mWXSDKInstance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            }
        }
        HashMap<String, Method> hashMap = methodsMap = (methodsMap = sGlobalModuleMethodMap.get(wxModule)) == null ? sInstanceModuleMethodMap.get(wxModule) : methodsMap;
        if (methodsMap == null) {
            methodsMap = WXModuleManager.getModuleMethods2Map(moduleClass);
            sInstanceModuleMethodMap.put(wxModule, methodsMap);
        }
        return wxModule;
    }

    public static void destroyInstanceModules(String instanceId) {
        HashMap<String, WXModule> moduleMap = sInstanceModuleMap.remove(instanceId);
        if (moduleMap == null || moduleMap.size() < 1) {
            return;
        }
        for (Map.Entry<String, WXModule> entry : moduleMap.entrySet()) {
            sInstanceModuleMethodMap.remove(entry.getValue());
        }
    }
}

