/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.adapter;

import android.text.TextUtils;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.http.WXHttpManager;
import com.taobao.weex.utils.WXLogUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Set;

public class DefaultWXHttpAdapter
implements IWXHttpAdapter {
    @Override
    public void sendRequest(final WXRequest request, final IWXHttpAdapter.OnHttpListener listener) {
        if (listener != null) {
            listener.onHttpStart();
        }
        WXHttpManager.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    WXResponse response = new WXResponse();
                    try {
                        HttpURLConnection connection = DefaultWXHttpAdapter.this.openConnection(request, listener);
                        int responseCode = connection.getResponseCode();
                        response.statusCode = String.valueOf(responseCode);
                        if (responseCode == 200 || responseCode == 202) {
                            response.originalData = DefaultWXHttpAdapter.this.readInputStream(connection.getInputStream(), listener).getBytes();
                        } else {
                            response.errorMsg = DefaultWXHttpAdapter.this.readInputStream(connection.getErrorStream(), listener);
                        }
                        if (listener != null) {
                            listener.onHttpFinish(response);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        response.errorCode = "-1";
                        response.errorMsg = e.getMessage();
                        if (listener == null) break block5;
                        listener.onHttpFinish(response);
                    }
                }
            }
        });
    }

    private HttpURLConnection openConnection(WXRequest request, IWXHttpAdapter.OnHttpListener listener) throws IOException {
        URL url = new URL(request.url);
        HttpURLConnection connection = this.createConnection(url);
        connection.setConnectTimeout(request.timeoutMs);
        connection.setReadTimeout(request.timeoutMs);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        if (!TextUtils.isEmpty((CharSequence)request.method)) {
            connection.setRequestMethod(request.method);
        }
        if (request.paramMap != null) {
            Set<String> keySets = request.paramMap.keySet();
            for (String key : keySets) {
                connection.addRequestProperty(key, request.paramMap.get(key).toString());
            }
        }
        if (request.body != null) {
            if (listener != null) {
                listener.onHttpUploadProgress(0);
            }
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(request.body.getBytes());
            out.close();
            if (listener != null) {
                listener.onHttpUploadProgress(100);
            }
        }
        return connection;
    }

    private String readInputStream(InputStream inputStream, IWXHttpAdapter.OnHttpListener listener) {
        StringBuilder builder = new StringBuilder();
        try {
            int fileLen = inputStream.available();
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] data = new char[2048];
            int len = -1;
            while ((len = localBufferedReader.read(data)) > 0) {
                builder.append(data, 0, len);
                if (listener == null || fileLen <= 0) continue;
                listener.onHttpResponseProgress(builder.length() / fileLen * 100);
            }
            localBufferedReader.close();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    WXLogUtils.e("DefaultWXHttpAdapter: " + WXLogUtils.getStackTrace(e));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    protected HttpURLConnection createConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }
}

