/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import com.taobao.weex.IWXActivityStateListener;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.DefaultWXHttpAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.http.WXHttpUtil;
import com.taobao.weex.ui.WXRecycleImageManager;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WXSDKInstance
implements IWXActivityStateListener {
    public boolean mEnd = false;
    protected IWXUserTrackAdapter mUserTrackAdapter;
    protected IWXHttpAdapter mWXHttpAdapter;
    private IWXRenderListener mRenderListener;
    private Context mContext;
    private volatile String mInstanceId;
    private WXComponent mRootCom;
    private boolean mRendered;
    private WXRefreshData mLastRefreshData;
    private WXRenderStrategy mRenderStrategy = WXRenderStrategy.APPEND_ASYNC;
    private int mGodViewWidth = -1;
    private int mGodViewHeight = -1;
    private long mRenderStartTime;
    private long mRefreshStartTime;
    private WXRecycleImageManager mRecycleImageManager;
    private ConcurrentLinkedQueue<IWXActivityStateListener> mActivityStateListeners;
    private WXPerformance mWXPerformance;
    private ScrollView mScrollView;
    private WXScrollView.WXScrollViewListener mWXScrollViewListener;
    private ViewGroup rootView;

    public WXComponent getRootCom() {
        return this.mRootCom;
    }

    public WXSDKInstance(Context context) {
        this.init(context);
    }

    public void init(Context context) {
        this.mContext = context;
        this.mActivityStateListeners = new ConcurrentLinkedQueue();
        this.mRecycleImageManager = new WXRecycleImageManager(this);
        this.mWXPerformance = new WXPerformance();
        this.mWXPerformance.WXSDKVersion = WXEnvironment.WXSDK_VERSION;
        this.mWXPerformance.JSLibInitTime = WXEnvironment.sJSLibInitTime;
        this.mUserTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
        this.mWXHttpAdapter = WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public void setBizType(String bizType) {
        if (!TextUtils.isEmpty((CharSequence)bizType)) {
            this.mWXPerformance.bizType = bizType;
        }
    }

    public ScrollView getScrollView() {
        return this.mScrollView;
    }

    public void setRootScrollView(ScrollView scrollView) {
        this.mScrollView = scrollView;
        if (this.mWXScrollViewListener != null) {
            ((WXScrollView)this.mScrollView).addScrollViewListener(this.mWXScrollViewListener);
        }
    }

    public void registerScrollViewListener(WXScrollView.WXScrollViewListener scrollViewListener) {
        this.mWXScrollViewListener = scrollViewListener;
    }

    public WXScrollView.WXScrollViewListener getScrollViewListener() {
        return this.mWXScrollViewListener;
    }

    @Deprecated
    public void setIWXUserTrackAdapter(IWXUserTrackAdapter adapter) {
    }

    public void render(String template, Map<String, Object> options, String jsonInitData) {
        this.render(template, options, jsonInitData, WXRenderStrategy.APPEND_ASYNC);
    }

    public void render(String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.render("default", template, options, jsonInitData, -1, -1, flag);
    }

    public void render(String pageName, String template, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag) {
        if (this.mRendered || TextUtils.isEmpty((CharSequence)template)) {
            return;
        }
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        if (WXEnvironment.sDynamicMode && !TextUtils.isEmpty((CharSequence)WXEnvironment.sDynamicUrl) && options != null && options.get("dynamicMode") == null) {
            options.put("dynamicMode", "true");
            this.renderByUrl(pageName, WXEnvironment.sDynamicUrl, options, jsonInitData, width, height, flag);
            return;
        }
        this.mWXPerformance.pageName = pageName;
        this.mWXPerformance.JSTemplateSize = template.length() / 1024;
        this.mRenderStartTime = System.currentTimeMillis();
        this.mRenderStrategy = flag;
        this.mGodViewWidth = width;
        this.mGodViewHeight = height;
        this.mInstanceId = WXSDKManager.getInstance().generateInstanceId();
        WXSDKManager.getInstance().createInstance(this, template, options, jsonInitData);
        this.mRendered = true;
    }

    public void render(String template, int width, int height) {
        this.render("default", template, null, null, width, height, this.mRenderStrategy);
    }

    public void renderByUrl(String pageName, String url, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag) {
        IWXHttpAdapter adapter = WXSDKManager.getInstance().getIWXHttpAdapter();
        if (adapter == null) {
            adapter = new DefaultWXHttpAdapter();
        }
        WXRequest wxRequest = new WXRequest();
        wxRequest.url = url;
        if (wxRequest.paramMap == null) {
            wxRequest.paramMap = new HashMap<String, Object>();
        }
        wxRequest.paramMap.put("user-agent", WXHttpUtil.assembleUserAgent());
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        if (!options.containsKey("bundleUrl")) {
            options.put("bundleUrl", url);
        }
        adapter.sendRequest(wxRequest, new WXHttpListener(pageName, options, jsonInitData, width, height, flag, System.currentTimeMillis()));
        this.mWXHttpAdapter = adapter;
    }

    public void refreshInstance(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.refreshInstance(WXJsonUtils.fromObjectToJSONString(data));
    }

    public void refreshInstance(String jsonData) {
        if (jsonData == null) {
            return;
        }
        this.mRefreshStartTime = System.currentTimeMillis();
        if (this.mLastRefreshData != null) {
            this.mLastRefreshData.isDirty = true;
        }
        this.mLastRefreshData = new WXRefreshData(jsonData, false);
        WXSDKManager.getInstance().refreshInstance(this.mInstanceId, this.mLastRefreshData);
    }

    public WXRenderStrategy getRenderStrategy() {
        return this.mRenderStrategy;
    }

    public String getInstanceId() {
        return this.mInstanceId;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getWeexHeight() {
        return this.mGodViewHeight;
    }

    public int getWeexWidth() {
        return this.mGodViewWidth;
    }

    public WXRecycleImageManager getRecycleImageManager() {
        return this.mRecycleImageManager;
    }

    public IWXImgLoaderAdapter getImgLoaderAdapter() {
        return WXSDKManager.getInstance().getIWXImgLoaderAdapter();
    }

    @Deprecated
    public void setImgLoaderAdapter(IWXImgLoaderAdapter adapter) {
    }

    public IWXHttpAdapter getWXHttpAdapter() {
        return WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public void reloadImages() {
        if (this.mScrollView == null) {
            return;
        }
        if (this.mRecycleImageManager != null) {
            WXSDKInstance wXSDKInstance = this;
            if (wXSDKInstance.mRecycleImageManager.isRecycleImage()) {
                WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (WXSDKInstance.this.mRecycleImageManager != null) {
                            WXSDKInstance.this.mRecycleImageManager.loadImage();
                        }
                    }
                }, 250L);
            }
        }
    }

    public void registerRenderListener(IWXRenderListener listener) {
        this.mRenderListener = listener;
    }

    public void registerActivityStateListener(IWXActivityStateListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.mActivityStateListeners.contains(listener)) {
            this.mActivityStateListeners.add(listener);
        }
    }

    @Override
    public void onActivityCreate() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityCreate();
        }
    }

    @Override
    public void onActivityStart() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityStart();
        }
    }

    @Override
    public void onActivityPause() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityPause();
        }
    }

    @Override
    public void onActivityResume() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityResume();
        }
    }

    @Override
    public void onActivityStop() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityStop();
        }
    }

    @Override
    public void onActivityDestroy() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            listener.onActivityDestroy();
        }
        this.destroy();
    }

    @Override
    public boolean onActivityBack() {
        for (IWXActivityStateListener listener : this.mActivityStateListeners) {
            boolean isIntercept = listener.onActivityBack();
            if (!isIntercept) continue;
            return true;
        }
        return false;
    }

    public void onViewCreated(final WXComponent component) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRootCom = component;
                        WXSDKInstance.this.mRenderListener.onViewCreated(WXSDKInstance.this, component.getView());
                    }
                }
            });
        }
    }

    public void runOnUiThread(Runnable action) {
        WXSDKManager.getInstance().postOnUiThread(action, 0L);
    }

    public void onRenderSuccess(final int width, final int height) {
        long time = System.currentTimeMillis() - this.mRenderStartTime;
        WXLogUtils.renderPerformanceLog("onRenderSuccess", time);
        this.mWXPerformance.totalTime = time;
        WXLogUtils.d(WXLogUtils.WEEX_PERF_TAG, "mComponentNum:" + WXComponent.mComponentNum);
        WXComponent.mComponentNum = 0;
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onRenderSuccess(WXSDKInstance.this, width, height);
                        if (WXEnvironment.isApkDebugable()) {
                            WXLogUtils.d(WXLogUtils.WEEX_PERF_TAG, WXSDKInstance.this.mWXPerformance.toString());
                        }
                        if (WXSDKInstance.this.mUserTrackAdapter != null) {
                            WXSDKInstance.this.mUserTrackAdapter.commit(WXSDKInstance.this.mContext, null, "load", WXSDKInstance.this.mWXPerformance, null);
                        }
                    }
                }
            });
        }
    }

    public void onRefreshSuccess(final int width, final int height) {
        WXLogUtils.renderPerformanceLog("onRefreshSuccess", System.currentTimeMillis() - this.mRefreshStartTime);
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onRefreshSuccess(WXSDKInstance.this, width, height);
                    }
                }
            });
        }
    }

    public void onRenderError(final String errCode, final String msg) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onException(WXSDKInstance.this, errCode, msg);
                    }
                }
            });
        }
    }

    public void onJSException(final String errCode, final String function, final String exception) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(function);
                        builder.append(exception);
                        WXSDKInstance.this.mRenderListener.onException(WXSDKInstance.this, errCode, builder.toString());
                    }
                }
            });
        }
    }

    public void firstScreenRenderFinished(long endTime) {
        this.mEnd = true;
        long time = endTime - this.mRenderStartTime;
        this.mWXPerformance.screenRenderTime = time;
        WXLogUtils.renderPerformanceLog("firstScreenRenderFinished", time);
    }

    public void createInstanceFinished(long time) {
        if (time > 0L) {
            this.mWXPerformance.communicateTime = time;
        }
    }

    public void commitUTStab(final String type, final WXErrorCode errorCode) {
        if (errorCode == WXErrorCode.WX_SUCCESS) {
            return;
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (WXSDKInstance.this.mUserTrackAdapter == null || TextUtils.isEmpty((CharSequence)type)) {
                    return;
                }
                if (errorCode.getErrorCode() == null && errorCode.getErrorMsg() == null) {
                    WXSDKInstance.this.mUserTrackAdapter.commit(WXSDKInstance.this.mContext, null, type, null, null);
                    return;
                }
                WXPerformance perf = new WXPerformance();
                perf.errCode = errorCode.getErrorCode();
                perf.errMsg = errorCode.getErrorMsg();
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(perf.toString());
                }
                WXSDKInstance.this.mUserTrackAdapter.commit(WXSDKInstance.this.mContext, null, type, perf, null);
            }
        });
    }

    private void destroyView(View rootView) {
        try {
            if (rootView instanceof ViewGroup) {
                ViewGroup cViewGroup = (ViewGroup)rootView;
                for (int index = 0; index < cViewGroup.getChildCount(); ++index) {
                    this.destroyView(cViewGroup.getChildAt(index));
                }
                cViewGroup.removeViews(0, ((ViewGroup)rootView).getChildCount());
                WXReflectionUtils.setValue(rootView, "mChildrenCount", 0);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("WXSDKInstance destroyView Exception: " + WXLogUtils.getStackTrace(e));
        }
    }

    public void destroy() {
        WXSDKManager.getInstance().destroyInstance(this.mInstanceId);
        if (this.mRecycleImageManager != null) {
            this.mRecycleImageManager.destroy();
            this.mRecycleImageManager = null;
        }
        if (this.mRootCom != null && this.mRootCom.getView() != null) {
            this.mRootCom.destroy();
            this.destroyView(this.mRootCom.getView());
            this.mRootCom = null;
        }
        if (this.mActivityStateListeners != null) {
            this.mActivityStateListeners.clear();
            this.mActivityStateListeners = null;
        }
        this.mContext = null;
        this.mRenderListener = null;
    }

    public ViewGroup getRootView() {
        return this.rootView;
    }

    public void setRootView(ViewGroup rootView) {
        this.rootView = rootView;
    }

    class WXHttpListener
    implements IWXHttpAdapter.OnHttpListener {
        private String pageName;
        private Map<String, Object> options;
        private String jsonInitData;
        private int width;
        private int height;
        private WXRenderStrategy flag;
        private long startRequestTime;

        private WXHttpListener(String pageName, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag, long startRequestTime) {
            this.pageName = pageName;
            this.options = options;
            this.jsonInitData = jsonInitData;
            this.width = width;
            this.height = height;
            this.flag = flag;
            this.startRequestTime = startRequestTime;
        }

        @Override
        public void onHttpStart() {
        }

        @Override
        public void onHttpUploadProgress(int uploadProgress) {
        }

        @Override
        public void onHttpResponseProgress(int responseProgress) {
        }

        @Override
        public void onHttpFinish(WXResponse response) {
            ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.networkTime = System.currentTimeMillis() - this.startRequestTime;
            WXLogUtils.renderPerformanceLog("networkTime", ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.networkTime);
            if (TextUtils.equals((CharSequence)"200", (CharSequence)response.statusCode)) {
                String template = new String(response.originalData);
                WXSDKInstance.this.render(this.pageName, template, this.options, this.jsonInitData, this.width, this.height, this.flag);
            } else if (TextUtils.equals((CharSequence)"wx_user_intercept_error", (CharSequence)response.statusCode)) {
                WXLogUtils.d("user intercept");
                WXSDKInstance.this.onRenderError("wx_user_intercept_error", response.errorMsg);
            } else {
                WXSDKInstance.this.onRenderError("wx_network_error", response.errorMsg);
            }
        }
    }
}

