/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.devtools.inspector.network.utils;

import android.support.annotation.Nullable;
import android.util.Pair;
import com.taobao.weex.devtools.inspector.network.NetworkEventReporter;
import com.taobao.weex.devtools.inspector.network.Timing;
import com.taobao.weex.devtools.inspector.network.utils.ExtractUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResponseConverter {
    public static NetworkEventReporter.InspectorResponse convertFrom(Map<String, Object> raw) {
        return new GeneralResponse(raw);
    }

    private static class GeneralResponse
    implements NetworkEventReporter.TimingInspectorResponse {
        private Map<String, Object> data;
        List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>(0);

        public GeneralResponse(Map<String, Object> data) {
            this.data = data;
            this.headers = ExtractUtil.getValue(data, "headers", this.headers);
        }

        @Override
        public String url() {
            return ExtractUtil.getValue(this.data, "url", "unknown");
        }

        @Override
        public boolean connectionReused() {
            return ExtractUtil.getValue(this.data, "connectionReused", false);
        }

        @Override
        public int connectionId() {
            return ExtractUtil.getValue(this.data, "connectionId", 0);
        }

        @Override
        public boolean fromDiskCache() {
            return ExtractUtil.getValue(this.data, "fromDiskCache", false);
        }

        @Override
        public String requestId() {
            return ExtractUtil.getValue(this.data, "requestId", "-1");
        }

        @Override
        public int statusCode() {
            return ExtractUtil.getValue(this.data, "statusCode", 200);
        }

        @Override
        public String reasonPhrase() {
            return ExtractUtil.getValue(this.data, "reasonPhrase", "OK");
        }

        @Override
        public int headerCount() {
            return this.headers.size();
        }

        @Override
        public String headerName(int index) {
            return (String)this.headers.get((int)index).first;
        }

        @Override
        public String headerValue(int index) {
            return (String)this.headers.get((int)index).second;
        }

        @Override
        @Nullable
        public String firstHeaderValue(String name) {
            for (Pair<String, String> pair : this.headers) {
                if (pair.first == null || !((String)pair.first).equalsIgnoreCase(name)) continue;
                return (String)pair.second;
            }
            return null;
        }

        @Override
        @Nullable
        public Timing resourceTiming() {
            Map<String, Object> statisticData = new HashMap();
            if ((statisticData = (Map)ExtractUtil.getValue(this.data, "timing", statisticData)).isEmpty()) {
                return null;
            }
            Timing timing = new Timing();
            timing.requestTime = this.optValue(statisticData, "requestTime");
            if (timing.requestTime == 0.0) {
                return null;
            }
            timing.proxyStart = this.optValue(statisticData, "sendBeforeTime") + this.optValue(statisticData, "waitingTime");
            timing.proxyEnd = timing.proxyStart + 0.0;
            timing.dnsStart = timing.proxyEnd + 0.0;
            timing.dnsEnd = timing.dnsStart + 0.0;
            timing.connectStart = timing.dnsEnd + 0.0;
            timing.sslStart = timing.connectStart + 0.0;
            timing.sendEnd = timing.sslStart + 0.0;
            timing.connectEnd = timing.connectStart + this.optValue(statisticData, "firstDataTime");
            timing.sendStart = timing.connectEnd + 0.0;
            timing.sendEnd = timing.sendStart + this.optValue(statisticData, "sendDataTime");
            timing.receiveHeadersEnd = timing.sendEnd + this.optValue(statisticData, "serverRT") + this.optValue(statisticData, "recDataTime");
            return timing;
        }

        private double optValue(Map<String, Object> data, String key) {
            try {
                Object val = data.get(key);
                if (val == null || val.toString().isEmpty()) {
                    return 0.0;
                }
                return Double.valueOf(data.get(key).toString());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
    }
}

