/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.devtools.inspector.network.utils;

import android.support.annotation.Nullable;
import android.util.Pair;
import com.taobao.weex.devtools.inspector.network.NetworkEventReporter;
import com.taobao.weex.devtools.inspector.network.utils.ExtractUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RequestConverter {
    public static NetworkEventReporter.InspectorRequest convertFrom(Map<String, Object> raw) {
        return new GeneralRequest(raw);
    }

    private static class GeneralRequest
    implements NetworkEventReporter.InspectorRequest {
        private Map<String, Object> data;
        List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>(0);

        public GeneralRequest(Map<String, Object> data) {
            this.data = data;
            this.headers = ExtractUtil.getValue(data, "headers", this.headers);
        }

        @Override
        @Nullable
        public Integer friendlyNameExtra() {
            return ExtractUtil.getValue(this.data, "friendlyNameExtra", null);
        }

        @Override
        public String url() {
            return ExtractUtil.getValue(this.data, "url", "unknown");
        }

        @Override
        public String method() {
            return ExtractUtil.getValue(this.data, "method", "GET");
        }

        @Override
        @Nullable
        public byte[] body() throws IOException {
            Object body = this.data.get("body");
            if (body != null) {
                if (body.getClass().isArray() && body.getClass().getComponentType().getName().equals("byte")) {
                    return (byte[])body;
                }
                if (body instanceof String) {
                    return ((String)body).getBytes();
                }
            }
            return new byte[0];
        }

        @Override
        public String id() {
            return ExtractUtil.getValue(this.data, "requestId", "-1");
        }

        @Override
        public String friendlyName() {
            return ExtractUtil.getValue(this.data, "friendlyName", "None");
        }

        @Override
        public int headerCount() {
            return this.headers.size();
        }

        @Override
        public String headerName(int index) {
            return (String)this.headers.get((int)index).first;
        }

        @Override
        public String headerValue(int index) {
            return (String)this.headers.get((int)index).second;
        }

        @Override
        @Nullable
        public String firstHeaderValue(String name) {
            for (Pair<String, String> pair : this.headers) {
                if (pair.first == null || !((String)pair.first).equalsIgnoreCase(name)) continue;
                return (String)pair.second;
            }
            return null;
        }
    }
}

