/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.devtools.inspector.network;

import com.taobao.weex.devtools.inspector.network.NetworkEventReporter;
import com.taobao.weex.devtools.inspector.network.ResponseHandler;
import java.io.IOException;

public class DefaultResponseHandler
implements ResponseHandler {
    private final NetworkEventReporter mEventReporter;
    private final String mRequestId;
    private int mBytesRead = 0;
    private int mDecodedBytesRead = -1;

    public DefaultResponseHandler(NetworkEventReporter eventReporter, String requestId) {
        this.mEventReporter = eventReporter;
        this.mRequestId = requestId;
    }

    @Override
    public void onRead(int numBytes) {
        this.mBytesRead += numBytes;
    }

    @Override
    public void onReadDecoded(int numBytes) {
        if (this.mDecodedBytesRead == -1) {
            this.mDecodedBytesRead = 0;
        }
        this.mDecodedBytesRead += numBytes;
    }

    @Override
    public void onEOF() {
        this.reportDataReceived();
        this.mEventReporter.responseReadFinished(this.mRequestId);
    }

    @Override
    public void onError(IOException e) {
        this.reportDataReceived();
        this.mEventReporter.responseReadFailed(this.mRequestId, e.toString());
    }

    private void reportDataReceived() {
        this.mEventReporter.dataReceived(this.mRequestId, this.mBytesRead, this.mDecodedBytesRead >= 0 ? this.mDecodedBytesRead : this.mBytesRead);
    }
}

