/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.devtools.inspector.network;

import android.support.annotation.Nullable;
import com.taobao.weex.devtools.inspector.network.NetworkEventReporter;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterOutputStream;

public class RequestBodyHelper {
    protected static final String GZIP_ENCODING = "gzip";
    protected static final String DEFLATE_ENCODING = "deflate";
    private final NetworkEventReporter mEventReporter;
    private final String mRequestId;
    private ByteArrayOutputStream mDeflatedOutput;
    private CountingOutputStream mDeflatingOutput;

    public RequestBodyHelper(NetworkEventReporter eventReporter, String requestId) {
        this.mEventReporter = eventReporter;
        this.mRequestId = requestId;
    }

    public OutputStream createBodySink(@Nullable String contentEncoding) throws IOException {
        ByteArrayOutputStream deflatedOutput = new ByteArrayOutputStream();
        OutputStream deflatingOutput = GZIP_ENCODING.equals(contentEncoding) ? GZipOutputStream.create(deflatedOutput) : (DEFLATE_ENCODING.equals(contentEncoding) ? new InflaterOutputStream(deflatedOutput) : deflatedOutput);
        this.mDeflatingOutput = new CountingOutputStream(deflatingOutput);
        this.mDeflatedOutput = deflatedOutput;
        return this.mDeflatingOutput;
    }

    public byte[] getDisplayBody() {
        this.throwIfNoBody();
        return this.mDeflatedOutput.toByteArray();
    }

    public boolean hasBody() {
        return this.mDeflatedOutput != null;
    }

    public void reportDataSent() {
        this.throwIfNoBody();
        this.mEventReporter.dataSent(this.mRequestId, this.mDeflatedOutput.size(), (int)this.mDeflatingOutput.getCount());
    }

    private void throwIfNoBody() {
        if (!this.hasBody()) {
            throw new IllegalStateException("No body found; has createBodySink been called?");
        }
    }

    static class GZipOutputStream
    extends FilterOutputStream {
        private final Future<Void> mCopyFuture;
        private static final ExecutorService sExecutor = Executors.newCachedThreadPool();

        public static GZipOutputStream create(OutputStream finalOut) throws IOException {
            PipedInputStream pipeIn = new PipedInputStream();
            PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
            Future<Void> copyFuture = sExecutor.submit(new GunzippingCallable(pipeIn, finalOut));
            return new GZipOutputStream(pipeOut, copyFuture);
        }

        private GZipOutputStream(OutputStream out, Future<Void> copyFuture) throws IOException {
            super(out);
            this.mCopyFuture = copyFuture;
        }

        @Override
        public void close() throws IOException {
            boolean success = false;
            try {
                super.close();
                success = true;
            }
            finally {
                block8: {
                    try {
                        GZipOutputStream.getAndRethrow(this.mCopyFuture);
                    }
                    catch (IOException e) {
                        if (!success) break block8;
                        throw e;
                    }
                }
            }
        }

        private static <T> T getAndRethrow(Future<T> future) throws IOException {
            while (true) {
                try {
                    return future.get();
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    GZipOutputStream.propagateIfInstanceOf(cause, IOException.class);
                    GZipOutputStream.propagate(cause);
                    continue;
                }
                break;
            }
        }

        private static <T extends Throwable> void propagateIfInstanceOf(Throwable t, Class<T> type) throws T {
            if (type.isInstance(t)) {
                throw t;
            }
        }

        private static RuntimeException propagate(Throwable t) {
            GZipOutputStream.propagateIfInstanceOf(t, Error.class);
            GZipOutputStream.propagateIfInstanceOf(t, RuntimeException.class);
            throw new RuntimeException(t);
        }

        private static void copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
            int n;
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
        }

        private static class GunzippingCallable
        implements Callable<Void> {
            private final InputStream mIn;
            private final OutputStream mOut;

            public GunzippingCallable(InputStream in, OutputStream out) {
                this.mIn = in;
                this.mOut = out;
            }

            @Override
            public Void call() throws IOException {
                GZIPInputStream in = new GZIPInputStream(this.mIn);
                try {
                    GZipOutputStream.copy(in, this.mOut, new byte[1024]);
                }
                finally {
                    in.close();
                    this.mOut.close();
                }
                return null;
            }
        }
    }

    private class CountingOutputStream
    extends FilterOutputStream {
        private long mCount;

        public CountingOutputStream(OutputStream out) {
            super(out);
        }

        public long getCount() {
            return this.mCount;
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.out.write(oneByte);
            ++this.mCount;
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            this.out.write(buffer, offset, length);
            this.mCount += (long)length;
        }
    }
}

