/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.Performance;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.core.reporter.MDSDataReporterFactory;
import com.taobao.weex.analyzer.view.AbstractAlertView;
import com.taobao.weex.analyzer.view.WXPerfHistoryItemView;
import com.taobao.weex.analyzer.view.WXPerfItemView;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class WXPerformanceAnalysisView
extends AbstractAlertView {
    private WXPerfItemView mPerfItemView;
    private WXPerfHistoryItemView mPerfHistoryItemView;
    private List<Performance> mHistoryPerfList;
    private Performance mCurPerformance;
    @Nullable
    private IDataReporter<Performance> mDataReporter;
    private AtomicInteger mCounter = new AtomicInteger(0);

    public WXPerformanceAnalysisView(Context context, @NonNull Performance curPerformance, @NonNull List<Performance> historyPerfs) {
        super(context);
        this.mCurPerformance = curPerformance;
        this.mHistoryPerfList = historyPerfs;
    }

    @Override
    protected void onInitView(@NonNull Window window) {
        this.mPerfItemView = (WXPerfItemView)window.findViewById(R.id.panel_cur_perf);
        this.mPerfHistoryItemView = (WXPerfHistoryItemView)window.findViewById(R.id.panel_history_perf);
        final TextView btnCurPanel = (TextView)window.findViewById(R.id.btn_cur_panel);
        final TextView btnHistoryPanel = (TextView)window.findViewById(R.id.btn_history_panel);
        window.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WXPerformanceAnalysisView.this.dismiss();
            }
        });
        btnCurPanel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                btnHistoryPanel.setTextColor(-16777216);
                btnHistoryPanel.setBackgroundColor(-1);
                btnCurPanel.setTextColor(-1);
                btnCurPanel.setBackgroundColor(Color.parseColor((String)"#03A9F4"));
                WXPerformanceAnalysisView.this.mPerfItemView.setVisibility(0);
                WXPerformanceAnalysisView.this.mPerfHistoryItemView.setVisibility(8);
            }
        });
        btnHistoryPanel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                btnCurPanel.setTextColor(-16777216);
                btnCurPanel.setBackgroundColor(-1);
                btnHistoryPanel.setTextColor(-1);
                btnHistoryPanel.setBackgroundColor(Color.parseColor((String)"#03A9F4"));
                WXPerformanceAnalysisView.this.mPerfHistoryItemView.setVisibility(0);
                WXPerformanceAnalysisView.this.mPerfItemView.setVisibility(8);
            }
        });
        String from = LaunchConfig.getFrom();
        String deviceId = LaunchConfig.getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)from) && !TextUtils.isEmpty((CharSequence)deviceId)) {
            this.mDataReporter = MDSDataReporterFactory.create(from, deviceId);
        }
    }

    @Override
    protected void onShown() {
        this.mPerfItemView.inflateData(this.mCurPerformance);
        this.mPerfHistoryItemView.inflateData(this.mHistoryPerfList);
        if (this.mDataReporter != null && this.mCurPerformance != null && this.mDataReporter.isEnabled()) {
            this.mDataReporter.report(new IDataReporter.ProcessedDataBuilder().sequenceId(this.mCounter.getAndIncrement()).data(this.mCurPerformance).deviceId(LaunchConfig.getDeviceId()).type("weex_performance_statistics").build());
        }
    }

    @Override
    protected int getLayoutResId() {
        return R.layout.wxt_weex_perf_analysis_view;
    }
}

