/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.TrafficTaskEntity;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.core.reporter.ReportSupportLoopTask;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.DynamicChartViewController;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.chart.ChartView;
import com.taobao.weex.analyzer.view.chart.LegendRenderer;
import com.taobao.weex.analyzer.view.chart.TimestampLabelFormatter;

public class TrafficSampleView
extends DragSupportOverlayView {
    private SampleTrafficTask mSampleTrafficTask;
    private DynamicChartViewController mChartViewController;
    private IOverlayView.OnCloseListener mOnCloseListener;

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    public TrafficSampleView(Context application) {
        super(application);
        this.mWidth = -1;
        this.mHeight = (int)ViewUtils.dp2px(application, 150);
    }

    @Override
    @NonNull
    protected View onCreateView() {
        int expectMaxTraffic = 64;
        this.mChartViewController = new DynamicChartViewController.Builder(this.mContext).title(this.mContext.getResources().getString(R.string.wxt_traffic)).titleOfAxisX(null).titleOfAxisY("kb/s").labelColor(-1).backgroundColor(Color.parseColor((String)"#ba000000")).lineColor(Color.parseColor((String)"#BACDDC39")).lineTitle("rx").lineTitle2("tx").lineColor2(Color.parseColor((String)"#6B673AB7")).isFill(true).fillColor(Color.parseColor((String)"#BACDDC39")).fillColor2(Color.parseColor((String)"#6B673AB7")).numXLabels(5).minX(0.0).maxX(20.0).numYLabels(5).minY(0.0).maxY(expectMaxTraffic).labelFormatter(new TimestampLabelFormatter()).maxDataPoints(22).build();
        LegendRenderer legendRenderer = ((ChartView)this.mChartViewController.getChartView()).getLegendRenderer();
        legendRenderer.setTextColor(-1);
        legendRenderer.setVisible(true);
        legendRenderer.setBackgroundColor(0);
        legendRenderer.setAlign(LegendRenderer.LegendAlign.TOP);
        legendRenderer.setMargin((int)ViewUtils.dp2px(this.mContext, 10));
        FrameLayout frameLayout = new FrameLayout(this.mContext);
        View chartView = this.mChartViewController.getChartView();
        frameLayout.addView(chartView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        TextView closeBtn = new TextView(this.mContext);
        closeBtn.setTextColor(-1);
        closeBtn.setText((CharSequence)this.mContext.getResources().getString(R.string.wxt_close));
        closeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TrafficSampleView.this.mOnCloseListener != null && TrafficSampleView.this.isViewAttached) {
                    TrafficSampleView.this.mOnCloseListener.close(TrafficSampleView.this);
                    TrafficSampleView.this.dismiss();
                }
            }
        });
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)ViewUtils.dp2px(this.mContext, 50), (int)ViewUtils.dp2px(this.mContext, 30));
        params.gravity = 5;
        frameLayout.addView((View)closeBtn, (ViewGroup.LayoutParams)params);
        return frameLayout;
    }

    @Override
    protected void onShown() {
        if (this.mSampleTrafficTask != null) {
            this.mSampleTrafficTask.stop();
            this.mSampleTrafficTask = null;
        }
        this.mSampleTrafficTask = new SampleTrafficTask(this.mChartViewController, SDKUtils.isDebugMode(this.mContext));
        this.mSampleTrafficTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mSampleTrafficTask != null) {
            this.mSampleTrafficTask.stop();
            this.mSampleTrafficTask = null;
        }
    }

    private static class SampleTrafficTask
    extends ReportSupportLoopTask<TrafficTaskEntity.TrafficInfo> {
        private boolean isDebug;
        private DynamicChartViewController mController;
        private static final float LOAD_FACTOR = 0.5f;
        private int mAxisXValue = -1;
        private TrafficTaskEntity mEntity;
        private static final int DELAY_IN_MILLIS = 1000;

        SampleTrafficTask(DynamicChartViewController controller, boolean isDebug) {
            super(false, 1000);
            this.isDebug = isDebug;
            this.mController = controller;
            this.mEntity = new TrafficTaskEntity(1000);
        }

        @Override
        protected void onStart() {
            this.mEntity.onTaskInit();
        }

        @Override
        protected void onRun() {
            TrafficTaskEntity.TrafficInfo info = this.mEntity.onTaskRun();
            final double txSpeed = info.txSpeed;
            final double rxSpeed = info.rxSpeed;
            if (this.isDebug) {
                Log.d((String)"weex-analyzer", (String)("network[tx:" + txSpeed + "kb/s,rx:" + rxSpeed + "kb/s]"));
            }
            this.reportIfNeeded(new IDataReporter.ProcessedDataBuilder().sequenceId(this.generateSequenceId()).deviceId(LaunchConfig.getDeviceId()).type("traffic").data(info).build());
            ++this.mAxisXValue;
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    double max = Math.max(rxSpeed, txSpeed);
                    if (SampleTrafficTask.this.checkIfNeedUpdateYAxis(max)) {
                        SampleTrafficTask.this.mController.updateAxisY(SampleTrafficTask.this.mController.getMinY(), (SampleTrafficTask.this.mController.getMaxY() - SampleTrafficTask.this.mController.getMinY()) * 2.0, 0);
                    }
                    SampleTrafficTask.this.mController.appendPointAndInvalidate(SampleTrafficTask.this.mAxisXValue, rxSpeed);
                    SampleTrafficTask.this.mController.appendPointAndInvalidate2(SampleTrafficTask.this.mAxisXValue, txSpeed);
                }
            });
        }

        private boolean checkIfNeedUpdateYAxis(double traffic) {
            double currentMaxY = this.mController.getMaxY() - this.mController.getMinY();
            return currentMaxY * 0.5 <= traffic;
        }

        @Override
        protected void onStop() {
            super.onStop();
            this.mEntity.onTaskStop();
        }
    }
}

