/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.alibaba.fastjson.JSON;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.NetworkEventInspector;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.core.reporter.MDSDataReporterFactory;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.view.AbstractResizableOverlayView;
import com.taobao.weex.analyzer.view.IOverlayView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class NetworkInspectorView
extends AbstractResizableOverlayView {
    private NetworkEventListAdapter mAdapter;
    private NetworkEventInspector mNetworkEventInspector;
    private IOverlayView.OnCloseListener mOnCloseListener;
    private boolean isSizeMenuOpened;
    @Nullable
    private IDataReporter<NetworkEventInspector.MessageBean> mDataReporter;
    private AtomicInteger mCounter = new AtomicInteger(0);

    public NetworkInspectorView(Context application) {
        super(application);
        this.mWidth = -1;
    }

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    @Override
    @NonNull
    protected View onCreateView() {
        View wholeView = View.inflate((Context)this.mContext, (int)R.layout.wxt_network_inspector_view, null);
        View clear = wholeView.findViewById(R.id.clear);
        clear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NetworkInspectorView.this.isViewAttached && NetworkInspectorView.this.mAdapter != null) {
                    NetworkInspectorView.this.mAdapter.clear();
                }
            }
        });
        final View hold = wholeView.findViewById(R.id.hold);
        hold.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NetworkInspectorView.this.mAdapter == null) {
                    return;
                }
                if (NetworkInspectorView.this.isViewAttached) {
                    if (NetworkInspectorView.this.mAdapter.isHoldModeEnabled()) {
                        NetworkInspectorView.this.mAdapter.setHoldModeEnabled(false);
                        ((TextView)hold).setText((CharSequence)"hold(off)");
                    } else {
                        NetworkInspectorView.this.mAdapter.setHoldModeEnabled(true);
                        ((TextView)hold).setText((CharSequence)"hold(on)");
                    }
                }
            }
        });
        View close = wholeView.findViewById(R.id.close);
        close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NetworkInspectorView.this.isViewAttached && NetworkInspectorView.this.mOnCloseListener != null) {
                    NetworkInspectorView.this.mOnCloseListener.close(NetworkInspectorView.this);
                    NetworkInspectorView.this.dismiss();
                }
            }
        });
        final RecyclerView networkEventList = (RecyclerView)wholeView.findViewById(R.id.list);
        networkEventList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.mAdapter = new NetworkEventListAdapter(this.mContext, networkEventList);
        networkEventList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        TextView sizeBtn = (TextView)wholeView.findViewById(R.id.size);
        final ViewGroup sizeContent = (ViewGroup)wholeView.findViewById(R.id.size_content);
        RadioGroup sizeGroup = (RadioGroup)wholeView.findViewById(R.id.height_group);
        sizeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NetworkInspectorView.this.isSizeMenuOpened = !NetworkInspectorView.this.isSizeMenuOpened;
                if (NetworkInspectorView.this.isSizeMenuOpened) {
                    sizeContent.setVisibility(0);
                } else {
                    sizeContent.setVisibility(8);
                }
            }
        });
        this.setViewSize(this.mViewSize, (View)networkEventList, false);
        switch (this.mViewSize) {
            case 0: {
                ((RadioButton)wholeView.findViewById(R.id.height_small)).setChecked(true);
                break;
            }
            case 1: {
                ((RadioButton)wholeView.findViewById(R.id.height_medium)).setChecked(true);
                break;
            }
            case 2: {
                ((RadioButton)wholeView.findViewById(R.id.height_large)).setChecked(true);
            }
        }
        sizeGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (checkedId == R.id.height_small) {
                    NetworkInspectorView.this.mViewSize = 0;
                } else if (checkedId == R.id.height_medium) {
                    NetworkInspectorView.this.mViewSize = 1;
                } else if (checkedId == R.id.height_large) {
                    NetworkInspectorView.this.mViewSize = 2;
                }
                NetworkInspectorView.this.setViewSize(NetworkInspectorView.this.mViewSize, (View)networkEventList, true);
            }
        });
        String from = LaunchConfig.getFrom();
        String deviceId = LaunchConfig.getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)from) && !TextUtils.isEmpty((CharSequence)deviceId)) {
            this.mDataReporter = MDSDataReporterFactory.create(from, deviceId);
        }
        return wholeView;
    }

    @Override
    protected void onShown() {
        this.mNetworkEventInspector = NetworkEventInspector.createInstance(this.mContext, new NetworkEventInspector.OnMessageReceivedListener(){

            @Override
            public void onMessageReceived(NetworkEventInspector.MessageBean msg) {
                if (NetworkInspectorView.this.mAdapter != null) {
                    NetworkInspectorView.this.mAdapter.addMessage(msg);
                }
                if (NetworkInspectorView.this.mDataReporter != null && msg != null && NetworkInspectorView.this.mDataReporter.isEnabled()) {
                    NetworkInspectorView.this.mDataReporter.report(new IDataReporter.ProcessedDataBuilder().sequenceId(NetworkInspectorView.this.mCounter.getAndIncrement()).data(msg).deviceId(LaunchConfig.getDeviceId()).type("mtop_inspector").build());
                }
            }
        });
    }

    @Override
    protected void onDismiss() {
        if (this.mNetworkEventInspector != null) {
            this.mNetworkEventInspector.destroy();
            this.mNetworkEventInspector = null;
        }
        this.mCounter.set(0);
    }

    private static class ViewHolder
    extends RecyclerView.ViewHolder {
        private NetworkEventInspector.MessageBean mCurMessage;
        private TextView bodyView;
        private TextView typeView;
        private TextView titleView;
        private TextView descView;
        private TextView timestampView;
        private View line;
        private static SimpleDateFormat sFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);

        ViewHolder(View itemView) {
            super(itemView);
            this.bodyView = (TextView)itemView.findViewById(R.id.body);
            this.typeView = (TextView)itemView.findViewById(R.id.type);
            this.titleView = (TextView)itemView.findViewById(R.id.title);
            this.descView = (TextView)itemView.findViewById(R.id.desc);
            this.timestampView = (TextView)itemView.findViewById(R.id.timestamp);
            this.line = itemView.findViewById(R.id.line);
            itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (ViewHolder.this.mCurMessage != null) {
                        try {
                            if (((ViewHolder)ViewHolder.this).mCurMessage.type != null && ((ViewHolder)ViewHolder.this).mCurMessage.type.equalsIgnoreCase("request")) {
                                if (!TextUtils.isEmpty((CharSequence)((ViewHolder)ViewHolder.this).mCurMessage.title)) {
                                    SDKUtils.copyToClipboard(v.getContext(), ((ViewHolder)ViewHolder.this).mCurMessage.title, true);
                                }
                            } else if (((ViewHolder)ViewHolder.this).mCurMessage.type != null && ((ViewHolder)ViewHolder.this).mCurMessage.type.equalsIgnoreCase("response") && !TextUtils.isEmpty((CharSequence)((ViewHolder)ViewHolder.this).mCurMessage.body)) {
                                SDKUtils.copyToClipboard(v.getContext(), ((ViewHolder)ViewHolder.this).mCurMessage.body, true);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
            });
        }

        void bind(@NonNull NetworkEventInspector.MessageBean msg) {
            String desc;
            this.mCurMessage = msg;
            this.typeView.setText((CharSequence)(TextUtils.isEmpty((CharSequence)msg.type) ? "UNKNOWN" : msg.type.toUpperCase()));
            this.titleView.setText((CharSequence)(TextUtils.isEmpty((CharSequence)msg.title) ? "null" : msg.title));
            String string2 = desc = TextUtils.isEmpty((CharSequence)msg.desc) ? "null" : msg.desc.toUpperCase();
            if (TextUtils.isEmpty((CharSequence)msg.type)) {
                this.descView.setText((CharSequence)desc);
                this.bodyView.setTextColor(-1);
                this.typeView.setTextColor(-1);
                this.titleView.setTextColor(-1);
                this.descView.setTextColor(-1);
                this.timestampView.setTextColor(-1);
            } else if ("request".equalsIgnoreCase(msg.type)) {
                this.descView.setText((CharSequence)("Method(" + desc + ")"));
                this.bodyView.setTextColor(Color.parseColor((String)"#2196F3"));
                this.typeView.setTextColor(Color.parseColor((String)"#2196F3"));
                this.titleView.setTextColor(Color.parseColor((String)"#2196F3"));
                this.descView.setTextColor(Color.parseColor((String)"#2196F3"));
                this.timestampView.setTextColor(Color.parseColor((String)"#2196F3"));
            } else if ("response".equalsIgnoreCase(msg.type)) {
                this.descView.setText((CharSequence)("Code(" + desc + ")"));
                this.bodyView.setTextColor(Color.parseColor((String)"#FFEB3B"));
                this.typeView.setTextColor(Color.parseColor((String)"#FFEB3B"));
                this.titleView.setTextColor(Color.parseColor((String)"#FFEB3B"));
                this.descView.setTextColor(Color.parseColor((String)"#FFEB3B"));
                this.timestampView.setTextColor(Color.parseColor((String)"#FFEB3B"));
            }
            this.timestampView.setText((CharSequence)ViewHolder.now());
            if (!TextUtils.isEmpty((CharSequence)msg.body)) {
                try {
                    if (msg.content != null) {
                        this.bodyView.setText((CharSequence)JSON.toJSONString((Object)msg.content, (boolean)true));
                    } else {
                        this.bodyView.setText((CharSequence)msg.body);
                    }
                }
                catch (Exception e) {
                    this.bodyView.setText((CharSequence)msg.body);
                }
                this.line.setVisibility(0);
                this.bodyView.setVisibility(0);
            } else {
                this.line.setVisibility(8);
                this.bodyView.setVisibility(8);
            }
        }

        private static String now() {
            return sFormatter.format(new Date());
        }
    }

    private static class NetworkEventListAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private List<NetworkEventInspector.MessageBean> mMessageList = new ArrayList<NetworkEventInspector.MessageBean>();
        private Context mContext;
        private boolean isHoldMode = false;
        private RecyclerView list;

        NetworkEventListAdapter(Context context, RecyclerView list) {
            this.mContext = context;
            this.list = list;
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.wxt_item_message, parent, false);
            return new ViewHolder(itemView);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            holder.bind(this.mMessageList.get(position));
        }

        public int getItemCount() {
            return this.mMessageList == null ? 0 : this.mMessageList.size();
        }

        void addMessage(@NonNull NetworkEventInspector.MessageBean msg) {
            this.mMessageList.add(msg);
            this.notifyItemInserted(this.mMessageList.size());
            if (!this.isHoldMode) {
                try {
                    this.list.smoothScrollToPosition(this.getItemCount() - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        void clear() {
            this.mMessageList.clear();
            this.notifyDataSetChanged();
        }

        void setHoldModeEnabled(boolean enabled) {
            this.isHoldMode = enabled;
        }

        boolean isHoldModeEnabled() {
            return this.isHoldMode;
        }
    }
}

