/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.IResizableView;

public abstract class AbstractResizableOverlayView
extends DragSupportOverlayView
implements IResizableView {
    private IResizableView.OnSizeChangedListener mOnSizeChangedListener;
    protected int mViewSize = 1;

    public AbstractResizableOverlayView(Context application) {
        super(application);
    }

    public void setOnSizeChangedListener(@NonNull IResizableView.OnSizeChangedListener listener) {
        this.mOnSizeChangedListener = listener;
    }

    public void setViewSize(int size) {
        this.mViewSize = size;
    }

    @Override
    public void setViewSize(int size, @Nullable View contentView, boolean allowFireEvent) {
        if (contentView == null) {
            return;
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)contentView.getLayoutParams();
        if (params == null) {
            return;
        }
        int heightSmall = (int)ViewUtils.dp2px(this.mContext, 200);
        int heightMedium = (int)ViewUtils.dp2px(this.mContext, 350);
        int heightLarge = -1;
        int height = params.height;
        switch (size) {
            case 0: {
                height = heightSmall;
                break;
            }
            case 1: {
                height = heightMedium;
                break;
            }
            case 2: {
                height = -1;
            }
        }
        if (height != params.height) {
            params.height = height;
            contentView.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.mOnSizeChangedListener != null && allowFireEvent) {
                this.mOnSizeChangedListener.onSizeChanged(size);
            }
        }
    }
}

