/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.utils;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.ui.component.WXA;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.component.WXEmbed;
import com.taobao.weex.ui.component.WXHeader;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.component.WXInput;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXSwitch;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.WXVideo;
import com.taobao.weex.ui.component.list.HorizontalListComponent;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ViewUtils {
    private static final Map<Class, String> sVDomMap = new HashMap<Class, String>();

    private ViewUtils() {
    }

    @NonNull
    public static String getComponentName(@NonNull WXComponent component) {
        String name = sVDomMap.get(component.getClass());
        return TextUtils.isEmpty((CharSequence)name) ? "component" : name;
    }

    public static float dp2px(@NonNull Context context, int dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float sp2px(@NonNull Context context, int sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float px2dp(@NonNull Context context, float px) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return px / ((float)metrics.densityDpi / 160.0f);
    }

    public static int getScreenHeight(@NonNull Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return metrics.heightPixels;
    }

    public static boolean isVerticalScroller(@NonNull WXScroller scroller) {
        return scroller.getDomObject() != null && scroller.getDomObject().getAttrs() != null && "vertical".equals(scroller.getDomObject().getAttrs().getScrollDirection());
    }

    @Nullable
    public static WXComponent getNestedRootComponent(@NonNull WXEmbed embed) {
        try {
            Class<?> embedClazz = embed.getClass();
            Field field = embedClazz.getDeclaredField("mNestedInstance");
            field.setAccessible(true);
            WXSDKInstance nestedInstance = (WXSDKInstance)field.get(embed);
            if (nestedInstance == null) {
                return null;
            }
            return nestedInstance.getRootComponent();
        }
        catch (Exception e) {
            WXLogUtils.e((String)e.getMessage());
            return null;
        }
    }

    public static double findSuitableVal(double value, int step) {
        if (value <= 0.0 || step <= 0) {
            return 0.0;
        }
        int temp = (int)value;
        while (temp % step != 0) {
            ++temp;
        }
        return temp;
    }

    static {
        sVDomMap.put(WXComponent.class, "component");
        sVDomMap.put(WXText.class, "text");
        sVDomMap.put(WXVContainer.class, "container");
        sVDomMap.put(WXDiv.class, "div");
        sVDomMap.put(WXEditText.class, "textarea");
        sVDomMap.put(WXA.class, "a");
        sVDomMap.put(WXInput.class, "input");
        sVDomMap.put(WXLoading.class, "loading");
        sVDomMap.put(WXScroller.class, "scroller");
        sVDomMap.put(WXSwitch.class, "switch");
        sVDomMap.put(WXSlider.class, "slider");
        sVDomMap.put(WXVideo.class, "video");
        sVDomMap.put(WXImage.class, "image");
        sVDomMap.put(WXHeader.class, "header");
        sVDomMap.put(WXEmbed.class, "embed");
        sVDomMap.put(WXListComponent.class, "list");
        sVDomMap.put(HorizontalListComponent.class, "hlist");
        sVDomMap.put(WXCell.class, "cell");
    }
}

