/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core.reporter;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.taobao.weex.utils.WXLogUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

final class HttpEngine {
    private static final String TAG = "HttpEngine";

    HttpEngine() {
    }

    public static void asyncRequest(final @NonNull Request request, final @NonNull OnHttpCompletedListener listener) {
        new AsyncTask<Request, Void, Response>(){

            protected Response doInBackground(Request ... params) {
                if (request.rawData != null && request.jsonData == null) {
                    try {
                        request.jsonData = JSON.toJSONString((Object)request.rawData);
                    }
                    catch (Exception e) {
                        request.jsonData = "{}";
                    }
                }
                WXLogUtils.d((String)"HttpDataReporter", (String)request.jsonData);
                return HttpEngine.syncRequest(params[0]);
            }

            protected void onPostExecute(Response response) {
                listener.onHttpComplete(response);
            }
        }.execute((Object[])new Request[]{request});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Response syncRequest(@NonNull Request request) {
        Response response = new Response();
        HttpURLConnection connection = null;
        String url = request.url;
        if (TextUtils.isEmpty((CharSequence)url)) {
            response.code = -1;
            response.message = "bad http request";
            return response;
        }
        try {
            int responseCode;
            URL requestUrl = new URL(url);
            connection = (HttpURLConnection)requestUrl.openConnection();
            String method = request.method;
            if (TextUtils.isEmpty((CharSequence)method)) {
                method = "GET";
            }
            connection.setRequestMethod(method);
            if (request.headers != null) {
                for (Map.Entry<String, String> header : request.headers.entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            connection.setRequestProperty("User-Agent", "com.taobao.weex.analyzer/1.0");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            if (request.jsonData != null) {
                byte[] compressedBody;
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                byte[] postData = request.jsonData.getBytes();
                if (postData.length > 80 && (compressedBody = HttpEngine.gzip(postData)) != null && postData.length - compressedBody.length > 80) {
                    postData = compressedBody;
                    connection.setRequestProperty("Content-Encoding", "gzip");
                }
                connection.setFixedLengthStreamingMode(postData.length);
                DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
                dos.write(postData);
                dos.flush();
            } else {
                connection.connect();
            }
            response.code = responseCode = connection.getResponseCode();
            String responseMsg = null;
            if (responseCode == 200) {
                InputStream inputStream = connection.getInputStream();
                if (inputStream != null) {
                    responseMsg = HttpEngine.readStream(inputStream);
                }
            } else {
                InputStream errorStream = connection.getErrorStream();
                if (errorStream != null) {
                    responseMsg = HttpEngine.readStream(errorStream);
                }
            }
            response.message = responseMsg;
            Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            WXLogUtils.e((String)TAG, (String)e.getMessage());
            response.code = -1;
            response.message = e.getMessage();
            Response response3 = response;
            return response3;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static String readStream(@NonNull InputStream stream) throws IOException {
        int count;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((count = stream.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        return new String(baos.toByteArray(), "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] gzip(byte[] input) {
        DeflaterOutputStream gzipOS = null;
        try {
            ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
            gzipOS = new GZIPOutputStream(byteArrayOS);
            gzipOS.write(input);
            gzipOS.flush();
            gzipOS.close();
            gzipOS = null;
            byte[] byArray = byteArrayOS.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (gzipOS != null) {
                try {
                    gzipOS.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class Const {
        static final String DEFAULT_USER_AGENT = "com.taobao.weex.analyzer/1.0";
        static final String APP_FORM = "application/x-www-form-urlencoded";
        static final String APP_JSON = "application/json";
        static final String APP_BINARY = "application/octet-stream";
        static final String TEXT_PLAIN = "text/plain";
        static final String HDR_CONTENT_TYPE = "Content-Type";
        static final String HDR_CONTENT_ENCODING = "Content-Encoding";
        static final String HDR_ACCEPT_ENCODING = "Accept-Encoding";
        static final String HDR_ACCEPT = "Accept";
        static final String HDR_USER_AGENT = "User-Agent";
        static final String UTF8 = "utf-8";
        static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        static final Class BYTE_ARRAY_CLASS = EMPTY_BYTE_ARRAY.getClass();
        static final int MIN_COMPRESSED_ADVANTAGE = 80;

        private Const() {
        }
    }

    public static interface OnHttpCompletedListener {
        public void onHttpComplete(Response var1);
    }

    public static class Request {
        String method;
        String url;
        Map<String, String> headers;
        String jsonData;
        Object rawData;
    }

    public static class Response {
        int code;
        String message;

        public String toString() {
            return "Response{code=" + this.code + ", message='" + this.message + '\'' + '}';
        }
    }
}

