/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core.reporter;

import android.support.annotation.NonNull;
import com.taobao.weex.analyzer.core.reporter.HttpEngine;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.utils.WXLogUtils;

class HttpDataReporter<T>
implements IDataReporter<T> {
    private String mRequestUrl;
    private boolean isEnabled;
    private static final String TAG = "HttpDataReporter";

    HttpDataReporter(String requestUrl, boolean isEnabled) {
        this.mRequestUrl = requestUrl;
        this.isEnabled = isEnabled;
    }

    @Override
    public void report(@NonNull IDataReporter.ProcessedData<T> data) {
        HttpEngine.Request request = new HttpEngine.Request();
        request.method = "POST";
        request.url = this.mRequestUrl;
        request.rawData = data;
        HttpEngine.asyncRequest(request, new HttpEngine.OnHttpCompletedListener(){

            @Override
            public void onHttpComplete(HttpEngine.Response response) {
                WXLogUtils.d((String)HttpDataReporter.TAG, (String)response.toString());
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }
}

