/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.app.Application;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.appfram.storage.DefaultWXStorage;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.storage.WXSQLiteOpenHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class StorageHacker {
    private IWXStorageAdapter mStorageAdapter;
    private Context mContext;
    private final boolean isDebug;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ExecutorService mExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(@NonNull Runnable r) {
            return new Thread(r, "wx_analyzer_storage_dumper");
        }
    });

    public StorageHacker(@NonNull Context context, boolean isDebug) {
        this.mStorageAdapter = WXSDKEngine.getIWXStorageAdapter();
        if (!(context instanceof Application)) {
            context = context.getApplicationContext();
        }
        this.mContext = context;
        this.isDebug = isDebug;
    }

    public void destroy() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.mExecutor != null) {
            this.mExecutor.shutdown();
            this.mExecutor = null;
        }
    }

    public boolean isDestroy() {
        return this.mHandler == null || this.mExecutor == null || this.mExecutor.isShutdown();
    }

    public void fetch(final @Nullable OnLoadListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mStorageAdapter == null) {
            listener.onLoad(Collections.emptyList());
            return;
        }
        if (!(this.mStorageAdapter instanceof DefaultWXStorage)) {
            listener.onLoad(Collections.emptyList());
            return;
        }
        if (this.isDestroy()) {
            listener.onLoad(Collections.emptyList());
            return;
        }
        this.mExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ArrayList<StorageInfo> resultList = new ArrayList<StorageInfo>();
                WXSQLiteOpenHelper helper = null;
                Cursor c = null;
                try {
                    Constructor constructor = WXSQLiteOpenHelper.class.getDeclaredConstructor(Context.class);
                    constructor.setAccessible(true);
                    helper = (WXSQLiteOpenHelper)constructor.newInstance(StorageHacker.this.mContext);
                    Method method = WXSQLiteOpenHelper.class.getDeclaredMethod("getDatabase", new Class[0]);
                    method.setAccessible(true);
                    SQLiteDatabase db = (SQLiteDatabase)method.invoke((Object)helper, new Object[0]);
                    c = db.query("default_wx_storage", new String[]{"key", "value", "timestamp"}, null, null, null, null, null);
                    if (StorageHacker.this.isDebug) {
                        Log.d((String)"weex-analyzer", (String)"start dump weex storage");
                    }
                    while (c.moveToNext()) {
                        StorageInfo info = new StorageInfo();
                        info.key = c.getString(c.getColumnIndex("key"));
                        info.value = c.getString(c.getColumnIndex("value"));
                        info.timestamp = c.getString(c.getColumnIndex("timestamp"));
                        if (StorageHacker.this.isDebug) {
                            Log.d((String)"weex-analyzer", (String)("weex storage[" + info.key + " | " + info.value + "]"));
                        }
                        resultList.add(info);
                    }
                    if (StorageHacker.this.isDebug) {
                        Log.d((String)"weex-analyzer", (String)"end dump weex storage");
                    }
                    if (StorageHacker.this.mHandler != null) {
                        StorageHacker.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onLoad(resultList);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                    if (helper != null) {
                        helper.closeDatabase();
                    }
                }
            }
        });
    }

    public void remove(final @Nullable String key, final @Nullable OnRemoveListener listener) {
        if (listener == null || TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (this.mStorageAdapter == null) {
            listener.onRemoved(false);
            return;
        }
        if (!(this.mStorageAdapter instanceof DefaultWXStorage)) {
            listener.onRemoved(false);
            return;
        }
        if (this.isDestroy()) {
            listener.onRemoved(false);
            return;
        }
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultWXStorage storage = (DefaultWXStorage)StorageHacker.this.mStorageAdapter;
                    Method method = storage.getClass().getDeclaredMethod("performRemoveItem", String.class);
                    if (method != null) {
                        method.setAccessible(true);
                        final boolean result = (Boolean)method.invoke((Object)storage, key);
                        if (StorageHacker.this.mHandler != null) {
                            StorageHacker.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onRemoved(result);
                                }
                            });
                            method.setAccessible(false);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static class StorageInfo {
        public String key;
        public String value;
        public String timestamp;
    }

    public static interface OnRemoveListener {
        public void onRemoved(boolean var1);
    }

    public static interface OnLoadListener {
        public void onLoad(List<StorageInfo> var1);
    }
}

