/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import java.util.Map;

public class NetworkEventSender {
    private LocalBroadcastManager mSender;
    public static final String INTENT_EXTRA_TYPE = "type";
    public static final String INTENT_EXTRA_TITLE = "title";
    public static final String INTENT_EXTRA_DESC = "desc";
    public static final String INTENT_EXTRA_BODY = "body";
    public static final String ACTION_NETWORK_REPORTER = "action_network_reporter";
    public static final String TYPE_REQUEST = "request";
    public static final String TYPE_RESPONSE = "response";

    public NetworkEventSender(Context context) {
        this.mSender = LocalBroadcastManager.getInstance((Context)context);
    }

    @VisibleForTesting
    NetworkEventSender(LocalBroadcastManager manager) {
        this.mSender = manager;
    }

    public void sendMessage(String type, String title, String desc, String body, Map<String, String> extendProps) {
        if (this.mSender == null) {
            return;
        }
        Intent intent = new Intent(ACTION_NETWORK_REPORTER);
        if (!TextUtils.isEmpty((CharSequence)type)) {
            intent.putExtra(INTENT_EXTRA_TYPE, type);
        }
        if (!TextUtils.isEmpty((CharSequence)title)) {
            intent.putExtra(INTENT_EXTRA_TITLE, title);
        }
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            intent.putExtra(INTENT_EXTRA_DESC, desc);
        }
        if (!TextUtils.isEmpty((CharSequence)body)) {
            intent.putExtra(INTENT_EXTRA_BODY, body);
        }
        if (extendProps != null && !extendProps.isEmpty()) {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : extendProps.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            intent.putExtras(bundle);
        }
        this.mSender.sendBroadcast(intent);
    }
}

