/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.HashMap;
import java.util.Map;

public class NetworkEventInspector {
    private LocalBroadcastManager mLocalBroadcastManager;
    private OnMessageReceivedListener mListener;
    private CoreMessageReceiver mCoreMessageReceiver;
    private static final String TAG = "NetworkEventInspector";

    private NetworkEventInspector(@NonNull Context context) {
        this.mLocalBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
    }

    private NetworkEventInspector(@NonNull LocalBroadcastManager manager) {
        this.mLocalBroadcastManager = manager;
    }

    private void setOnMessageReceivedListener(@NonNull OnMessageReceivedListener listener) {
        this.mListener = listener;
        this.mCoreMessageReceiver = new CoreMessageReceiver(this.mListener);
        IntentFilter filter = new IntentFilter("action_network_reporter");
        this.mLocalBroadcastManager.registerReceiver((BroadcastReceiver)this.mCoreMessageReceiver, filter);
    }

    public static NetworkEventInspector createInstance(@NonNull Context context, @NonNull OnMessageReceivedListener listener) {
        NetworkEventInspector reporter = new NetworkEventInspector(context);
        reporter.setOnMessageReceivedListener(listener);
        return reporter;
    }

    @VisibleForTesting
    @NonNull
    static NetworkEventInspector createInstance(@NonNull LocalBroadcastManager manager, @NonNull OnMessageReceivedListener listener) {
        NetworkEventInspector reporter = new NetworkEventInspector(manager);
        reporter.setOnMessageReceivedListener(listener);
        return reporter;
    }

    public void destroy() {
        if (this.mCoreMessageReceiver != null && this.mLocalBroadcastManager != null) {
            this.mLocalBroadcastManager.unregisterReceiver((BroadcastReceiver)this.mCoreMessageReceiver);
            this.mCoreMessageReceiver = null;
            this.mLocalBroadcastManager = null;
        }
        this.mListener = null;
    }

    public static class MessageBean {
        public String title;
        public String desc;
        public String type;
        @JSONField(serialize=false)
        public String body;
        public JSONObject content;
        @JSONField(serialize=false)
        public Map<String, String> extendProps;

        public MessageBean(String type, String title, String desc, Map<String, String> extendProps, String body) {
            this.type = type;
            this.title = title;
            this.desc = desc;
            this.extendProps = extendProps;
            this.body = body;
        }
    }

    public static interface OnMessageReceivedListener {
        public void onMessageReceived(MessageBean var1);
    }

    static class CoreMessageReceiver
    extends BroadcastReceiver {
        OnMessageReceivedListener listener;

        CoreMessageReceiver(@NonNull OnMessageReceivedListener listener) {
            this.listener = listener;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null || !intent.getAction().equals("action_network_reporter")) {
                return;
            }
            String type = intent.getStringExtra("type");
            String title = intent.getStringExtra("title");
            String desc = intent.getStringExtra("desc");
            String body = intent.getStringExtra("body");
            Bundle bundle = intent.getExtras();
            HashMap<String, String> extendProps = null;
            if (bundle != null) {
                extendProps = new HashMap<String, String>();
                for (String key : bundle.keySet()) {
                    if ("type".equals(key) || "desc".equals(key) || "title".equals(key) || "body".equals(key)) continue;
                    extendProps.put(key, bundle.getString(key));
                }
            }
            MessageBean msg = new MessageBean(type, title, desc, extendProps, body);
            try {
                if (!TextUtils.isEmpty((CharSequence)msg.body)) {
                    msg.content = JSON.parseObject((String)msg.body.trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.listener != null) {
                this.listener.onMessageReceived(msg);
            }
        }
    }
}

