/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.taobao.weex.analyzer.WeexDevOptions;
import com.taobao.weex.analyzer.core.AnalyzerService;
import com.taobao.weex.analyzer.core.PollingVDomMonitor;
import com.taobao.weex.analyzer.core.VDomController;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.utils.WXLogUtils;

public class LaunchAnalyzerReceiver
extends BroadcastReceiver {
    private static final String ACTION = "com.taobao.weex.analyzer.LaunchService";
    private static final String CMD_PERFORMANCE = "c";
    private static final String CMD_TRACKER_STANDARD = "d";
    private static final String CMD_TRACKER_POLLING = "f";
    private static final String CMD_LAUNCH_UI = "launch";
    private static final String TRUE = "true";
    private static final String CMD_ON = "on";
    private static final String CMD_OFF = "off";

    public void onReceive(Context context, Intent intent) {
        if (!ACTION.equals(intent.getAction())) {
            return;
        }
        String cmd_performance = intent.getStringExtra(CMD_PERFORMANCE);
        String cmd_tracker_standard = intent.getStringExtra(CMD_TRACKER_STANDARD);
        String cmd_tracker_polling = intent.getStringExtra(CMD_TRACKER_POLLING);
        String cmd_launch_ui = intent.getStringExtra(CMD_LAUNCH_UI);
        if (!TextUtils.isEmpty((CharSequence)cmd_performance)) {
            if (CMD_ON.equals(cmd_performance)) {
                this.performStart(context);
            } else if (CMD_OFF.equals(cmd_performance)) {
                this.performStop(context);
            } else {
                Log.d((String)"weex-analyzer", (String)"illegal command. use [adb shell am broadcast -a com.taobao.weex.analyzer.LaunchService -e c on] to fetch performance data");
            }
        } else if (!TextUtils.isEmpty((CharSequence)cmd_tracker_standard)) {
            if (CMD_ON.equals(cmd_tracker_standard)) {
                VDomController.isStandardMode = true;
                VDomController.isPollingMode = false;
            } else if (CMD_OFF.equals(cmd_tracker_standard)) {
                VDomController.isStandardMode = false;
            } else {
                Log.d((String)"weex-analyzer", (String)"illegal command. use [adb shell am broadcast -a com.taobao.weex.analyzer.LaunchService -e d on] to start vdom tracker");
            }
        } else if (!TextUtils.isEmpty((CharSequence)cmd_tracker_polling)) {
            if (CMD_ON.equals(cmd_tracker_polling)) {
                VDomController.isPollingMode = true;
                VDomController.isStandardMode = false;
                PollingVDomMonitor.shouldStop = false;
            } else if (CMD_OFF.equals(cmd_tracker_polling)) {
                VDomController.isPollingMode = false;
                PollingVDomMonitor.shouldStop = true;
            } else {
                Log.d((String)"weex-analyzer", (String)"illegal command. use [adb shell am broadcast -a com.taobao.weex.analyzer.LaunchService -e f on] to start vdom tracker(polling mode)");
            }
        } else if (!TextUtils.isEmpty((CharSequence)cmd_launch_ui) && TRUE.equals(cmd_launch_ui)) {
            String from = intent.getStringExtra("from");
            String deviceId = intent.getStringExtra("deviceId");
            WeexDevOptions.launchByBroadcast(context, TextUtils.isEmpty((CharSequence)from) ? "NULL" : from, deviceId);
        }
    }

    private void performStart(@NonNull Context context) {
        if (!SDKUtils.isHostRunning(context) || !SDKUtils.isInteractive(context)) {
            Log.d((String)"weex-analyzer", (String)"service start failed(host app is not in foreground,is your app running?)");
            return;
        }
        WXLogUtils.d((String)"weex-analyzer", (String)"analyzer service will start...");
        Intent intent = new Intent(context, AnalyzerService.class);
        context.startService(intent);
    }

    private void performStop(@NonNull Context context) {
        Intent intent = new Intent(context, AnalyzerService.class);
        context.stopService(intent);
    }
}

