/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.DevOptionsConfig;
import com.taobao.weex.analyzer.view.CompatibleAlertDialogBuilder;
import java.util.Locale;

public class JSExceptionCatcher {
    private static final int ID = 4097;

    private JSExceptionCatcher() {
    }

    @Nullable
    public static AlertDialog catchException(@Nullable Context context, @Nullable DevOptionsConfig config, @Nullable WXSDKInstance instance, @Nullable String errCode, @Nullable String msg) {
        if (context == null) {
            return null;
        }
        if (errCode == null && msg == null) {
            return null;
        }
        if (config != null && config.isAllowExceptionNotification()) {
            JSExceptionCatcher.sendNotification(context, instance, errCode, msg);
        }
        CompatibleAlertDialogBuilder builder = new CompatibleAlertDialogBuilder(context);
        builder.setTitle("WeexAnalyzer\u6355\u6349\u5230\u5f02\u5e38");
        builder.setMessage(String.format(Locale.CHINA, "errorCode : %s\nerrorMsg : %s\n", TextUtils.isEmpty((CharSequence)errCode) ? "unknown" : errCode, TextUtils.isEmpty((CharSequence)msg) ? "unknown" : msg));
        builder.setPositiveButton("okay", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
        return dialog;
    }

    private static void sendNotification(@NonNull Context context, @Nullable WXSDKInstance instance, @Nullable String errCode, @Nullable String msg) {
        String bundleUrl = null;
        if (instance != null) {
            bundleUrl = instance.getBundleUrl();
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setSmallIcon(R.drawable.wxt_icon_debug).setContentTitle((CharSequence)"WeexAnalyzer\u6355\u6349\u5230\u5f02\u5e38").setAutoCancel(true).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)String.format(Locale.CHINA, "page : %s\nerrorCode : %s\nerrorMsg : %s\n", TextUtils.isEmpty((CharSequence)bundleUrl) ? "unknown" : bundleUrl, TextUtils.isEmpty((CharSequence)errCode) ? "unknown" : errCode, TextUtils.isEmpty((CharSequence)msg) ? "unknown" : msg))).setContentText((CharSequence)String.format(Locale.CHINA, "errorCode : %s,errorMsg : %s", TextUtils.isEmpty((CharSequence)errCode) ? "unknown" : errCode, TextUtils.isEmpty((CharSequence)msg) ? "unknown" : msg));
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setVisibility(1);
        }
        builder.setDefaults(3);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(4097, builder.build());
    }
}

