/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.core.ComponentHeightComputer;
import com.taobao.weex.analyzer.pojo.HealthReport;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXEmbed;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Locale;

public class DomTracker {
    private WXSDKInstance mWxInstance;
    private Deque<LayeredNode<WXComponent>> mLayeredQueue;
    private ObjectPool<LayeredNode<WXComponent>> mVDomObjectPool;
    private ObjectPool<LayeredNode<View>> mRealDomObjectPool;
    private static final String TAG = "VDomTracker";
    private OnTrackNodeListener mOnTrackNodeListener;
    private static final int START_LAYER_OF_VDOM = 2;
    private static final int START_LAYER_OF_REAL_DOM = 2;

    public DomTracker(@NonNull WXSDKInstance instance) {
        this.mWxInstance = instance;
        this.mLayeredQueue = new ArrayDeque<LayeredNode<WXComponent>>();
        this.mVDomObjectPool = new ObjectPool<LayeredNode<WXComponent>>(10){

            @Override
            LayeredNode<WXComponent> newObject() {
                return new LayeredNode<WXComponent>();
            }
        };
        this.mRealDomObjectPool = new ObjectPool<LayeredNode<View>>(15){

            @Override
            LayeredNode<View> newObject() {
                return new LayeredNode<View>();
            }
        };
    }

    public void setOnTrackNodeListener(OnTrackNodeListener listener) {
        this.mOnTrackNodeListener = listener;
    }

    @Nullable
    public HealthReport traverse() {
        long start = System.currentTimeMillis();
        if (SDKUtils.isInUiThread()) {
            WXLogUtils.e((String)TAG, (String)"illegal thread...");
            return null;
        }
        int pageHeight = 0;
        WXComponent godComponent = this.mWxInstance.getRootComponent();
        if (godComponent == null) {
            WXLogUtils.e((String)TAG, (String)"god component not found");
            return null;
        }
        HealthReport report = new HealthReport(this.mWxInstance.getBundleUrl());
        View hostView = godComponent.getHostView();
        if (hostView != null) {
            report.maxLayerOfRealDom = this.getRealDomMaxLayer(hostView);
            pageHeight = hostView.getMeasuredHeight();
        }
        LayeredNode<WXComponent> layeredNode = this.mVDomObjectPool.obtain();
        layeredNode.set(godComponent, ViewUtils.getComponentName(godComponent), 2);
        this.mLayeredQueue.add(layeredNode);
        while (!this.mLayeredQueue.isEmpty()) {
            LayeredNode<WXComponent> domNode = this.mLayeredQueue.removeFirst();
            WXComponent component = (WXComponent)domNode.component;
            int layer = domNode.layer;
            report.maxLayer = Math.max(report.maxLayer, layer);
            report.estimateContentHeight = Math.max(report.estimateContentHeight, ComponentHeightComputer.computeComponentContentHeight(component));
            if (!TextUtils.isEmpty((CharSequence)domNode.tint)) {
                for (HealthReport.EmbedDesc desc : report.embedDescList) {
                    if (desc.src == null || !desc.src.equals(domNode.tint)) continue;
                    desc.actualMaxLayer = Math.max(desc.actualMaxLayer, layer - desc.beginLayer);
                }
            }
            if (this.mOnTrackNodeListener != null) {
                this.mOnTrackNodeListener.onTrackNode(component, layer);
            }
            if (component instanceof WXListComponent) {
                HealthReport.ListDesc listDesc;
                report.hasList = true;
                if (report.listDescMap == null) {
                    report.listDescMap = new LinkedHashMap<String, HealthReport.ListDesc>();
                }
                if ((listDesc = report.listDescMap.get(component.getRef())) == null) {
                    listDesc = new HealthReport.ListDesc();
                }
                listDesc.ref = component.getRef();
                listDesc.totalHeight = ComponentHeightComputer.computeComponentContentHeight(component);
                report.listDescMap.put(listDesc.ref, listDesc);
            } else if (component instanceof WXScroller) {
                if (ViewUtils.isVerticalScroller((WXScroller)component)) {
                    report.hasScroller = true;
                }
            } else if (component instanceof WXCell) {
                HealthReport.ListDesc listDesc;
                WXVContainer parentContainer = component.getParent();
                if (parentContainer != null && parentContainer instanceof WXListComponent && report.listDescMap != null && (listDesc = report.listDescMap.get(parentContainer.getRef())) != null) {
                    ++listDesc.cellNum;
                }
                int num = this.getComponentNumOfNode(component);
                report.maxCellViewNum = Math.max(report.maxCellViewNum, num);
                if (((WXCell)component).getHostView() != null) {
                    int height = ((WXFrameLayout)((WXCell)component).getHostView()).getMeasuredHeight();
                    report.hasBigCell |= this.isBigCell(height);
                    report.componentNumOfBigCell = num;
                }
            } else if (component instanceof WXEmbed) {
                report.hasEmbed = true;
            }
            domNode.clear();
            this.mVDomObjectPool.recycle(domNode);
            if (component instanceof WXEmbed) {
                if (report.embedDescList == null) {
                    report.embedDescList = new ArrayList<HealthReport.EmbedDesc>();
                }
                HealthReport.EmbedDesc desc = new HealthReport.EmbedDesc();
                desc.src = ((WXEmbed)component).getSrc();
                desc.beginLayer = layer;
                report.embedDescList.add(desc);
                WXComponent nestedRootComponent = ViewUtils.getNestedRootComponent((WXEmbed)component);
                if (nestedRootComponent == null) continue;
                LayeredNode<WXComponent> childNode = this.mVDomObjectPool.obtain();
                childNode.set(nestedRootComponent, ViewUtils.getComponentName(nestedRootComponent), layer + 1);
                this.mLayeredQueue.add(childNode);
                childNode.tint = desc.src;
                continue;
            }
            if (!(component instanceof WXVContainer)) continue;
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = 0; i < count; ++i) {
                WXComponent child = container.getChild(i);
                LayeredNode<WXComponent> childNode = this.mVDomObjectPool.obtain();
                childNode.set(child, ViewUtils.getComponentName(child), layer + 1);
                if (!TextUtils.isEmpty((CharSequence)domNode.tint)) {
                    childNode.tint = domNode.tint;
                }
                this.mLayeredQueue.add(childNode);
            }
        }
        Context context = this.mWxInstance.getContext();
        if (context != null) {
            pageHeight = pageHeight == 0 ? ViewUtils.getScreenHeight(context) : pageHeight;
        }
        report.estimatePages = pageHeight != 0 ? String.format(Locale.CHINA, "%.2f", (double)report.estimateContentHeight / (double)pageHeight) : "0";
        long end = System.currentTimeMillis();
        WXLogUtils.d((String)TAG, (String)("[traverse] elapse time :" + (end - start) + "ms"));
        return report;
    }

    private int getComponentNumOfNode(@NonNull WXComponent rootNode) {
        ArrayDeque<WXComponent> deque = new ArrayDeque<WXComponent>();
        deque.add(rootNode);
        int viewNum = 0;
        while (!deque.isEmpty()) {
            WXComponent node = (WXComponent)deque.removeFirst();
            ++viewNum;
            if (!(node instanceof WXVContainer)) continue;
            WXVContainer container = (WXVContainer)node;
            int count = container.childCount();
            for (int i = 0; i < count; ++i) {
                deque.add(container.getChild(i));
            }
        }
        return viewNum;
    }

    int getRealDomMaxLayer(@NonNull View rootView) {
        int maxLayer = 0;
        ArrayDeque<LayeredNode<View>> deque = new ArrayDeque<LayeredNode<View>>();
        LayeredNode<View> rootNode = this.mRealDomObjectPool.obtain();
        rootNode.set(rootView, null, 2);
        deque.add(rootNode);
        while (!deque.isEmpty()) {
            LayeredNode currentNode = (LayeredNode)deque.removeFirst();
            maxLayer = Math.max(maxLayer, currentNode.layer);
            View component = (View)currentNode.component;
            int layer = currentNode.layer;
            currentNode.clear();
            this.mRealDomObjectPool.recycle(currentNode);
            if (!(component instanceof ViewGroup) || ((ViewGroup)component).getChildCount() <= 0) continue;
            ViewGroup viewGroup = (ViewGroup)component;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = viewGroup.getChildAt(i);
                LayeredNode<View> childNode = this.mRealDomObjectPool.obtain();
                childNode.set(child, null, layer + 1);
                deque.add(childNode);
            }
        }
        return maxLayer;
    }

    private boolean isBigCell(float maxHeight) {
        if (maxHeight <= 0.0f) {
            return false;
        }
        return (double)maxHeight > (double)(WXViewUtils.getScreenHeight() * 2) / 3.0;
    }

    private static abstract class ObjectPool<T> {
        private final Deque<T> mPool;

        ObjectPool(int capacity) {
            capacity = Math.max(0, capacity);
            this.mPool = new ArrayDeque<T>(capacity);
            for (int i = 0; i < capacity; ++i) {
                this.mPool.add(this.newObject());
            }
        }

        abstract T newObject();

        T obtain() {
            return this.mPool.isEmpty() ? this.newObject() : this.mPool.removeLast();
        }

        void recycle(@NonNull T obj) {
            this.mPool.addLast(obj);
        }
    }

    private static class LayeredNode<T> {
        T component;
        String simpleName;
        int layer;
        String tint;

        private LayeredNode() {
        }

        void set(T component, String simpleName, int layer) {
            this.component = component;
            this.layer = layer;
            this.simpleName = simpleName;
        }

        void clear() {
            this.component = null;
            this.layer = -1;
            this.simpleName = null;
        }
    }

    public static interface OnTrackNodeListener {
        public void onTrackNode(@NonNull WXComponent var1, int var2);
    }
}

