/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.taobao.weex.analyzer.core.AbstractLoopTask;
import com.taobao.weex.analyzer.core.CpuTaskEntity;
import com.taobao.weex.analyzer.core.FpsTaskEntity;
import com.taobao.weex.analyzer.core.MemoryTaskEntity;
import com.taobao.weex.analyzer.core.TaskEntity;
import com.taobao.weex.analyzer.core.TrafficTaskEntity;
import com.taobao.weex.analyzer.utils.SDKUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class AnalyzerService
extends Service {
    private TaskImpl mTask;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.createTask();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)"weex-analyzer", (String)"service start success");
        if (this.mTask == null) {
            this.createTask();
        }
        this.mTask.start();
        return 3;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mTask != null) {
            this.mTask.stop();
        }
        Log.d((String)"weex-analyzer", (String)"service is destroyed");
    }

    private void createTask() {
        this.mTask = new TaskImpl((Context)this, 1000);
    }

    private static class TaskImpl
    extends AbstractLoopTask {
        private WeakReference<Context> mHostRef;
        private List<TaskEntity> mTaskEntities;

        TaskImpl(@NonNull Context context, int delayMillis) {
            super(false, delayMillis);
            this.mHostRef = new WeakReference<Context>(context);
            this.mTaskEntities = new ArrayList<TaskEntity>();
            this.mTaskEntities.add(new CpuTaskEntity());
            this.mTaskEntities.add(new TrafficTaskEntity(delayMillis));
            this.mTaskEntities.add(new MemoryTaskEntity());
            this.mTaskEntities.add(new FpsTaskEntity());
        }

        @Override
        protected void onStart() {
            if (this.mTaskEntities != null && !this.mTaskEntities.isEmpty()) {
                for (TaskEntity entity : this.mTaskEntities) {
                    entity.onTaskInit();
                }
            }
        }

        @Override
        protected void onRun() {
            if (this.mHostRef.get() != null && !SDKUtils.isHostRunning((Context)this.mHostRef.get()) || this.mHostRef.get() != null && !SDKUtils.isInteractive((Context)this.mHostRef.get())) {
                Log.d((String)"weex-analyzer", (String)"service is stopped because we are in background or killed");
                ((Service)this.mHostRef.get()).stopSelf();
                return;
            }
            CpuTaskEntity.CpuInfo cpuInfo = null;
            TrafficTaskEntity.TrafficInfo trafficInfo = null;
            double memoryUsage = 0.0;
            double fps = 0.0;
            if (this.mTaskEntities != null && !this.mTaskEntities.isEmpty()) {
                for (TaskEntity entity : this.mTaskEntities) {
                    if (entity instanceof CpuTaskEntity) {
                        cpuInfo = (CpuTaskEntity.CpuInfo)entity.onTaskRun();
                        continue;
                    }
                    if (entity instanceof TrafficTaskEntity) {
                        trafficInfo = (TrafficTaskEntity.TrafficInfo)entity.onTaskRun();
                        continue;
                    }
                    if (entity instanceof MemoryTaskEntity) {
                        memoryUsage = (Double)entity.onTaskRun();
                        continue;
                    }
                    if (!(entity instanceof FpsTaskEntity)) continue;
                    fps = (Double)entity.onTaskRun();
                }
            }
            if (cpuInfo != null) {
                Log.d((String)"weex-analyzer", (String)("cpu usage(total :" + String.format("%.2f", cpuInfo.pidCpuUsage) + "% user : " + String.format("%.2f", cpuInfo.pidUserCpuUsage) + "% kernel : " + String.format("%.2f", cpuInfo.pidKernelCpuUsage) + "%)\r\n"));
            }
            Log.d((String)"weex-analyzer", (String)("memory usage : " + String.format("%.2f", memoryUsage) + "MB\r\n"));
            Log.d((String)"weex-analyzer", (String)("fps : " + String.format("%.2f", fps) + "\r\n"));
            if (trafficInfo != null) {
                Log.d((String)"weex-analyzer", (String)("traffic speed(rx :" + String.format("%.2f", trafficInfo.rxSpeed) + "kb/s tx : " + String.format("%.2f", trafficInfo.txSpeed) + "kb/s)\r\n\r\n"));
            }
        }

        @Override
        protected void onStop() {
            if (this.mTaskEntities != null && !this.mTaskEntities.isEmpty()) {
                for (TaskEntity entity : this.mTaskEntities) {
                    entity.onTaskStop();
                }
            }
        }
    }
}

