/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.TextView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.AbstractLoopTask;
import com.taobao.weex.analyzer.core.VDomTracker;
import com.taobao.weex.analyzer.pojo.HealthReport;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;

public class VDomDepthSampleView
extends DragSupportOverlayView {
    private SampleTask mTask;

    public VDomDepthSampleView(Context application) {
        super(application);
    }

    @Override
    @NonNull
    protected View onCreateView() {
        return View.inflate((Context)this.mContext, (int)R.layout.wxt_depth_sample_view, null);
    }

    @Override
    protected void onShown() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
        this.mTask = new SampleTask(this.mWholeView);
        this.mTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
    }

    public void bindInstance(WXSDKInstance instance) {
        if (this.mTask != null) {
            this.mTask.setInstance(instance);
        }
    }

    private static class SampleTask
    extends AbstractLoopTask {
        WXSDKInstance instance;
        TextView resultTextView;

        SampleTask(@NonNull View hostView) {
            super(false);
            this.mDelayMillis = 1000;
            this.resultTextView = (TextView)hostView.findViewById(R.id.result);
        }

        void setInstance(WXSDKInstance instance) {
            this.instance = instance;
        }

        @Override
        protected void onRun() {
            if (this.instance == null) {
                return;
            }
            VDomTracker tracker = new VDomTracker(this.instance);
            HealthReport report = tracker.traverse();
            if (report == null) {
                return;
            }
            final StringBuilder builder = new StringBuilder();
            builder.append("*weex-analyzer\u68c0\u6d4b\u7ed3\u679c:\n");
            builder.append("*\u5f53\u524d\u9875\u9762VDom\u6700\u6df1\u5c42\u7ea7\u4e3a ").append(report.maxLayer + 1).append("\n");
            if (report.maxLayer + 1 >= 15) {
                builder.append("*\u5c42\u7ea7\u8fc7\u6df1\uff0c\u5efa\u8bae\u4f18\u5316\n");
            } else {
                builder.append("*\u5c42\u7ea7\u5408\u7406\n");
            }
            if (report.hasList) {
                builder.append("*\u4f7f\u7528\u4e86list\u7ec4\u4ef6,cell\u4e2a\u6570\u4e3a").append(report.cellNum).append("\n");
                builder.append("*\u6700\u5927\u7684cell\u5305\u542b\u4e86").append(report.maxCellViewNum).append("\u4e2a\u7ec4\u4ef6\n");
                if (report.hasBigCell) {
                    builder.append("*\u53ef\u80fd\u5b58\u5728\u5927cell,\u5bf9\u6027\u80fd\u4ea7\u751f\u5f71\u54cd\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\n");
                }
            }
            if (report.hasScroller) {
                builder.append("*\u4f7f\u7528\u4e86Scroller\u7ec4\u4ef6\n");
            }
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    SampleTask.this.resultTextView.setText((CharSequence)builder.toString());
                }
            });
        }

        @Override
        protected void onStop() {
            this.instance = null;
        }
    }
}

