/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view.chart;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import com.taobao.weex.analyzer.view.chart.BaseSeries;
import com.taobao.weex.analyzer.view.chart.ChartView;
import com.taobao.weex.analyzer.view.chart.DataPointInterface;
import java.util.Iterator;

public class LineGraphSeries<E extends DataPointInterface>
extends BaseSeries<E> {
    private static final long ANIMATION_DURATION = 333L;
    private Styles mStyles;
    private Paint mPaint;
    private Paint mPaintBackground;
    private Path mPathBackground;
    private Path mPath;
    private Paint mCustomPaint;
    private boolean mAnimated;
    private double mLastAnimatedValue = Double.NaN;
    private long mAnimationStart;
    private AccelerateInterpolator mAnimationInterpolator;
    private int mAnimationStartFrameNo;
    private boolean mDrawAsPath = false;

    public LineGraphSeries() {
        this.init();
    }

    public LineGraphSeries(E[] data) {
        super(data);
        this.init();
    }

    protected void init() {
        this.mStyles = new Styles();
        this.mPaint = new Paint();
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaintBackground = new Paint();
        this.mPathBackground = new Path();
        this.mPath = new Path();
        this.mAnimationInterpolator = new AccelerateInterpolator(2.0f);
    }

    @Override
    public void draw(ChartView graphView, Canvas canvas) {
        this.resetDataPoints();
        double maxX = graphView.getViewport().getMaxX(false);
        double minX = graphView.getViewport().getMinX(false);
        double maxY = graphView.getViewport().getMaxY(false);
        double minY = graphView.getViewport().getMinY(false);
        Iterator values = this.getValues(minX, maxX);
        double lastEndY = 0.0;
        double lastEndX = 0.0;
        this.mPaint.setStrokeWidth((float)this.mStyles.thickness);
        this.mPaint.setColor(this.getColor());
        this.mPaintBackground.setColor(this.mStyles.backgroundColor);
        Paint paint = this.mCustomPaint != null ? this.mCustomPaint : this.mPaint;
        this.mPath.reset();
        if (this.mStyles.drawBackground) {
            this.mPathBackground.reset();
        }
        double diffY = maxY - minY;
        double diffX = maxX - minX;
        float graphHeight = graphView.getGraphContentHeight();
        float graphWidth = graphView.getGraphContentWidth();
        float graphLeft = graphView.getGraphContentLeft();
        float graphTop = graphView.getGraphContentTop();
        lastEndY = 0.0;
        lastEndX = 0.0;
        double lastUsedEndX = 0.0;
        double lastUsedEndY = 0.0;
        float firstX = -1.0f;
        float firstY = -1.0f;
        float lastRenderedX = 0.0f;
        int i = 0;
        float lastAnimationReferenceX = graphLeft;
        while (values.hasNext()) {
            double x;
            DataPointInterface value = (DataPointInterface)values.next();
            double valY = value.getY() - minY;
            double ratY = valY / diffY;
            double y = (double)graphHeight * ratY;
            double valueX = value.getX();
            double valX = valueX - minX;
            double ratX = valX / diffX;
            double orgX = x = (double)graphWidth * ratX;
            double orgY = y;
            if (i > 0) {
                double b;
                double b2;
                boolean isOverdrawY = false;
                boolean isOverdrawEndPoint = false;
                boolean skipDraw = false;
                if (x > (double)graphWidth) {
                    b2 = ((double)graphWidth - lastEndX) * (y - lastEndY) / (x - lastEndX);
                    y = lastEndY + b2;
                    x = graphWidth;
                    isOverdrawEndPoint = true;
                }
                if (y < 0.0) {
                    if (lastEndY < 0.0) {
                        skipDraw = true;
                    } else {
                        b2 = (0.0 - lastEndY) * (x - lastEndX) / (y - lastEndY);
                        x = lastEndX + b2;
                    }
                    y = 0.0;
                    isOverdrawEndPoint = true;
                    isOverdrawY = true;
                }
                if (y > (double)graphHeight) {
                    if (lastEndY > (double)graphHeight) {
                        skipDraw = true;
                    } else {
                        b2 = ((double)graphHeight - lastEndY) * (x - lastEndX) / (y - lastEndY);
                        x = lastEndX + b2;
                    }
                    y = graphHeight;
                    isOverdrawEndPoint = true;
                    isOverdrawY = true;
                }
                if (lastEndX < 0.0) {
                    b2 = (0.0 - x) * (y - lastEndY) / (lastEndX - x);
                    lastEndY = y - b2;
                    lastEndX = 0.0;
                }
                float orgStartX = (float)lastEndX + (graphLeft + 1.0f);
                if (lastEndY < 0.0) {
                    if (!skipDraw) {
                        b = (0.0 - y) * (x - lastEndX) / (lastEndY - y);
                        lastEndX = x - b;
                    }
                    lastEndY = 0.0;
                    isOverdrawY = true;
                }
                if (lastEndY > (double)graphHeight) {
                    if (!skipDraw) {
                        b = ((double)graphHeight - y) * (x - lastEndX) / (lastEndY - y);
                        lastEndX = x - b;
                    }
                    lastEndY = graphHeight;
                    isOverdrawY = true;
                }
                float startX = (float)lastEndX + (graphLeft + 1.0f);
                float startY = (float)((double)graphTop - lastEndY) + graphHeight;
                float endX = (float)x + (graphLeft + 1.0f);
                float endY = (float)((double)graphTop - y) + graphHeight;
                float startXAnimated = startX;
                float endXAnimated = endX;
                if (endX < startX) {
                    skipDraw = true;
                }
                if (!(skipDraw || Float.isNaN(startY) || Float.isNaN(endY))) {
                    if (this.mAnimated) {
                        if (Double.isNaN(this.mLastAnimatedValue) || this.mLastAnimatedValue < valueX) {
                            long currentTime = System.currentTimeMillis();
                            if (this.mAnimationStart == 0L) {
                                this.mAnimationStart = currentTime;
                                this.mAnimationStartFrameNo = 0;
                            } else if (this.mAnimationStartFrameNo < 15) {
                                this.mAnimationStart = currentTime;
                                ++this.mAnimationStartFrameNo;
                            }
                            float timeFactor = (float)(currentTime - this.mAnimationStart) / 333.0f;
                            float factor = this.mAnimationInterpolator.getInterpolation(timeFactor);
                            if ((double)timeFactor <= 1.0) {
                                startXAnimated = (startX - lastAnimationReferenceX) * factor + lastAnimationReferenceX;
                                startXAnimated = Math.max(startXAnimated, lastAnimationReferenceX);
                                endXAnimated = (endX - lastAnimationReferenceX) * factor + lastAnimationReferenceX;
                                ViewCompat.postInvalidateOnAnimation((View)graphView);
                            } else {
                                this.mLastAnimatedValue = valueX;
                            }
                        } else {
                            lastAnimationReferenceX = endX;
                        }
                    }
                    if (!isOverdrawEndPoint) {
                        if (this.mStyles.drawDataPoints) {
                            Paint.Style prevStyle = paint.getStyle();
                            paint.setStyle(Paint.Style.FILL);
                            canvas.drawCircle(endXAnimated, endY, this.mStyles.dataPointsRadius, paint);
                            paint.setStyle(prevStyle);
                        }
                        this.registerDataPoint(endX, endY, value);
                    }
                    if (this.mDrawAsPath) {
                        this.mPath.moveTo(startXAnimated, startY);
                    }
                    if (Math.abs(endX - lastRenderedX) > 0.3f) {
                        if (this.mDrawAsPath) {
                            this.mPath.lineTo(endXAnimated, endY);
                        } else {
                            this.renderLine(canvas, new float[]{startXAnimated, startY, endXAnimated, endY}, paint);
                        }
                        lastRenderedX = endX;
                    }
                }
                if (this.mStyles.drawBackground) {
                    if (isOverdrawY) {
                        if (firstX == -1.0f) {
                            firstX = orgStartX;
                            firstY = startY;
                            this.mPathBackground.moveTo(orgStartX, startY);
                        }
                        this.mPathBackground.lineTo(startXAnimated, startY);
                    }
                    if (firstX == -1.0f) {
                        firstX = startXAnimated;
                        firstY = startY;
                        this.mPathBackground.moveTo(startXAnimated, startY);
                    }
                    this.mPathBackground.lineTo(startXAnimated, startY);
                    this.mPathBackground.lineTo(endXAnimated, endY);
                }
                lastUsedEndX = endXAnimated;
                lastUsedEndY = endY;
            } else if (this.mStyles.drawDataPoints) {
                float first_X = (float)x + (graphLeft + 1.0f);
                float first_Y = (float)((double)graphTop - y) + graphHeight;
                if (first_X >= graphLeft && first_Y <= graphTop + graphHeight) {
                    if (this.mAnimated && (Double.isNaN(this.mLastAnimatedValue) || this.mLastAnimatedValue < valueX)) {
                        long currentTime = System.currentTimeMillis();
                        if (this.mAnimationStart == 0L) {
                            this.mAnimationStart = currentTime;
                        }
                        float timeFactor = (float)(currentTime - this.mAnimationStart) / 333.0f;
                        float factor = this.mAnimationInterpolator.getInterpolation(timeFactor);
                        if ((double)timeFactor <= 1.0) {
                            first_X = (first_X - lastAnimationReferenceX) * factor + lastAnimationReferenceX;
                            ViewCompat.postInvalidateOnAnimation((View)graphView);
                        } else {
                            this.mLastAnimatedValue = valueX;
                        }
                    }
                    Paint.Style prevStyle = paint.getStyle();
                    paint.setStyle(Paint.Style.FILL);
                    canvas.drawCircle(first_X, first_Y, this.mStyles.dataPointsRadius, paint);
                    paint.setStyle(prevStyle);
                }
            }
            lastEndY = orgY;
            lastEndX = orgX;
            ++i;
        }
        if (this.mDrawAsPath) {
            canvas.drawPath(this.mPath, paint);
        }
        if (this.mStyles.drawBackground && firstX != -1.0f) {
            if (lastUsedEndY != (double)(graphHeight + graphTop)) {
                this.mPathBackground.lineTo((float)lastUsedEndX, graphHeight + graphTop);
            }
            this.mPathBackground.lineTo(firstX, graphHeight + graphTop);
            if (firstY != graphHeight + graphTop) {
                this.mPathBackground.lineTo(firstX, firstY);
            }
            canvas.drawPath(this.mPathBackground, this.mPaintBackground);
        }
    }

    private void renderLine(Canvas canvas, float[] pts, Paint paint) {
        canvas.drawLines(pts, paint);
    }

    public int getThickness() {
        return this.mStyles.thickness;
    }

    public void setThickness(int thickness) {
        this.mStyles.thickness = thickness;
    }

    public boolean isDrawBackground() {
        return this.mStyles.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.mStyles.drawBackground = drawBackground;
    }

    public boolean isDrawDataPoints() {
        return this.mStyles.drawDataPoints;
    }

    public void setDrawDataPoints(boolean drawDataPoints) {
        this.mStyles.drawDataPoints = drawDataPoints;
    }

    public float getDataPointsRadius() {
        return this.mStyles.dataPointsRadius;
    }

    public void setDataPointsRadius(float dataPointsRadius) {
        this.mStyles.dataPointsRadius = dataPointsRadius;
    }

    public int getBackgroundColor() {
        return this.mStyles.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mStyles.backgroundColor = backgroundColor;
    }

    public void setCustomPaint(Paint customPaint) {
        this.mCustomPaint = customPaint;
    }

    public void setAnimated(boolean animated) {
        this.mAnimated = animated;
    }

    public boolean isDrawAsPath() {
        return this.mDrawAsPath;
    }

    public void setDrawAsPath(boolean mDrawAsPath) {
        this.mDrawAsPath = mDrawAsPath;
    }

    @Override
    public void appendData(E dataPoint, boolean scrollToEnd, int maxDataPoints, boolean silent) {
        if (!this.isAnimationActive()) {
            this.mAnimationStart = 0L;
        }
        super.appendData(dataPoint, scrollToEnd, maxDataPoints, silent);
    }

    private boolean isAnimationActive() {
        if (this.mAnimated) {
            long curr = System.currentTimeMillis();
            return curr - this.mAnimationStart <= 333L;
        }
        return false;
    }

    private final class Styles {
        private int thickness = 5;
        private boolean drawBackground = false;
        private boolean drawDataPoints = false;
        private float dataPointsRadius = 10.0f;
        private int backgroundColor = Color.argb((int)100, (int)172, (int)218, (int)255);

        private Styles() {
        }
    }
}

