/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.ScalpelFrameLayout;
import com.taobao.weex.analyzer.view.SimpleOverlayView;

public class ScalpelViewController {
    private boolean isScalpelEnabled = false;
    private boolean isDrawId = false;
    private boolean isDrawViewName = false;
    private SimpleOverlayView mSwitchView;
    private ScalpelFrameLayout mScalpelLayout;
    private OnToggleListener mOnToggleListener;
    private ScalpelFrameLayout.OnDrawViewNameListener mOnDrawViewNameListener;
    private Context mContext;

    public ScalpelViewController(Context context) {
        this(false, false, true, context);
    }

    public ScalpelViewController(boolean enabled, boolean isDrawId, boolean isDrawViewName, Context context) {
        this.isScalpelEnabled = enabled;
        this.isDrawId = isDrawId;
        this.isDrawViewName = isDrawViewName;
        this.mContext = context;
        this.mSwitchView = new SimpleOverlayView.Builder(this.mContext, "close").enableDrag(false).listener(new SimpleOverlayView.OnClickListener(){

            @Override
            public void onClick(@NonNull IOverlayView view) {
                ScalpelViewController.this.setScalpelEnabled(false);
            }
        }).gravity(53).y((int)ViewUtils.dp2px(this.mContext, 60)).build();
    }

    public void setOnToggleListener(OnToggleListener listener) {
        this.mOnToggleListener = listener;
    }

    public void setOnDrawViewNameListener(ScalpelFrameLayout.OnDrawViewNameListener listener) {
        this.mOnDrawViewNameListener = listener;
    }

    public View wrapView(@Nullable View view) {
        if (view == null) {
            return null;
        }
        this.mScalpelLayout = new ScalpelFrameLayout(view.getContext());
        this.mScalpelLayout.setDrawIds(this.isDrawId);
        this.mScalpelLayout.setDrawViewNames(this.isDrawViewName);
        if (this.mOnDrawViewNameListener != null) {
            this.mScalpelLayout.setOnDrawViewNameListener(this.mOnDrawViewNameListener);
        }
        this.mScalpelLayout.addView(view);
        this.mScalpelLayout.setLayerInteractionEnabled(this.isScalpelEnabled);
        return this.mScalpelLayout;
    }

    public boolean isScalpelEnabled() {
        return this.isScalpelEnabled;
    }

    public void setScalpelEnabled(boolean enabled) {
        this.isScalpelEnabled = enabled;
        if (this.mScalpelLayout != null) {
            this.mScalpelLayout.setLayerInteractionEnabled(this.isScalpelEnabled);
            if (enabled) {
                this.mSwitchView.show();
            } else {
                this.mSwitchView.dismiss();
            }
            if (this.mOnToggleListener != null) {
                this.mOnToggleListener.onToggle((View)this.mScalpelLayout, this.isScalpelEnabled);
            }
        }
    }

    public boolean isDrawIdEnabled() {
        return this.isDrawId;
    }

    public void setDrawId(boolean enabled) {
        this.isDrawId = enabled;
        if (this.mScalpelLayout != null) {
            this.mScalpelLayout.setDrawIds(this.isDrawId);
        }
    }

    public boolean isDrawViewNameEnabled() {
        return this.isDrawViewName;
    }

    public void setDrawViewName(boolean enabled) {
        this.isDrawViewName = enabled;
        if (this.mScalpelLayout != null) {
            this.mScalpelLayout.setDrawViewNames(this.isDrawViewName);
        }
    }

    public void toggleScalpelEnabled() {
        boolean bl = this.isScalpelEnabled = !this.isScalpelEnabled;
        if (this.mScalpelLayout == null) {
            return;
        }
        this.setScalpelEnabled(this.isScalpelEnabled);
    }

    public void pause() {
        if (this.mSwitchView != null && this.isScalpelEnabled) {
            this.mSwitchView.dismiss();
        }
    }

    public void resume() {
        if (this.mSwitchView != null && this.isScalpelEnabled) {
            this.mSwitchView.show();
        }
    }

    public static interface OnToggleListener {
        public void onToggle(View var1, boolean var2);
    }
}

