/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.Toast;
import com.taobao.weex.WXSDKEngine;

public class SDKUtils {
    private SDKUtils() {
    }

    public static boolean isWXInitialized() {
        return WXSDKEngine.isInitialized();
    }

    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static void copyToClipboard(@NonNull Context context, @Nullable String text, boolean allowNotification) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        ClipboardManager manager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"copied text", (CharSequence)text);
        manager.setPrimaryClip(clip);
        if (allowNotification) {
            Toast.makeText((Context)context, (CharSequence)"copied to clipboard success", (int)0).show();
        }
    }

    public static boolean isDebugMode(@NonNull Context context) {
        boolean isDebug = false;
        try {
            ApplicationInfo info = context.getApplicationInfo();
            isDebug = (info.flags & 2) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDebug;
    }
}

